/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.APersistentSet;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.PersistentTreeMap;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import java.util.Comparator;

public class PersistentTreeSet
extends APersistentSet
implements IObj,
Reversible,
Sorted {
    public static final PersistentTreeSet EMPTY = new PersistentTreeSet(null, PersistentTreeMap.EMPTY);
    final IPersistentMap _meta;

    public static PersistentTreeSet create(ISeq items) {
        PersistentTreeSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentTreeSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    public static PersistentTreeSet create(Comparator comp2, ISeq items) {
        PersistentTreeSet ret = new PersistentTreeSet(null, new PersistentTreeMap(null, comp2));
        while (items != null) {
            ret = (PersistentTreeSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    PersistentTreeSet(IPersistentMap meta, IPersistentMap impl) {
        super(impl);
        this._meta = meta;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return super.equals(obj);
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    @Override
    public boolean equiv(Object obj) {
        try {
            return super.equiv(obj);
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    @Override
    public IPersistentSet disjoin(Object key2) {
        if (this.contains(key2)) {
            return new PersistentTreeSet(this.meta(), this.impl.without(key2));
        }
        return this;
    }

    @Override
    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentTreeSet(this.meta(), this.impl.assoc(o, o));
    }

    @Override
    public IPersistentCollection empty() {
        return new PersistentTreeSet(this.meta(), (PersistentTreeMap)this.impl.empty());
    }

    @Override
    public ISeq rseq() {
        return APersistentMap.KeySeq.create(((Reversible)((Object)this.impl)).rseq());
    }

    @Override
    public PersistentTreeSet withMeta(IPersistentMap meta) {
        if (this.meta() == meta) {
            return this;
        }
        return new PersistentTreeSet(meta, this.impl);
    }

    @Override
    public Comparator comparator() {
        return ((Sorted)((Object)this.impl)).comparator();
    }

    @Override
    public Object entryKey(Object entry2) {
        return entry2;
    }

    @Override
    public ISeq seq(boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seq(ascending));
    }

    @Override
    public ISeq seqFrom(Object key2, boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seqFrom(key2, ascending));
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }
}

