/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    public static final int CHUNK_SIZE = 12;
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContentResponse = false;
    private Boolean _persistent = null;
    private Supplier<HttpFields> _trailers = null;
    private final int _send;
    private static final int SEND_SERVER = 1;
    private static final int SEND_XPOWEREDBY = 2;
    private static final Trie<Boolean> ASSUMED_CONTENT_METHODS = new ArrayTrie<Boolean>(8);
    private boolean _needCRLF = false;
    private static final byte[] ZERO_CHUNK;
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] HTTP_1_1_SPACE;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static final byte[][] SEND;
    private static final PreparedResponse[] __preprepared;

    public static void setJettyVersion(String serverVersion) {
        HttpGenerator.SEND[1] = StringUtil.getBytes("Server: " + serverVersion + "\r\n");
        HttpGenerator.SEND[2] = StringUtil.getBytes("X-Powered-By: " + serverVersion + "\r\n");
        HttpGenerator.SEND[3] = StringUtil.getBytes("Server: " + serverVersion + "\r\nX-Powered-By: " + serverVersion + "\r\n");
    }

    public HttpGenerator() {
        this(false, false);
    }

    public HttpGenerator(boolean sendServerVersion, boolean sendXPoweredBy) {
        this._send = (sendServerVersion ? 1 : 0) | (sendXPoweredBy ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContentResponse = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._trailers = null;
    }

    @Deprecated
    public boolean getSendServerVersion() {
        return (this._send & 1) != 0;
    }

    @Deprecated
    public void setSendServerVersion(boolean sendServerVersion) {
        throw new UnsupportedOperationException();
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    public boolean isIdle() {
        return this._state == State.START;
    }

    public boolean isEnd() {
        return this._state == State.END;
    }

    public boolean isCommitted() {
        return this._state.ordinal() >= State.COMMITTED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isNoContent() {
        return this._noContentResponse;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this._persistent);
    }

    public boolean isWritten() {
        return this._contentPrepared > 0L;
    }

    public long getContentPrepared() {
        return this._contentPrepared;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(MetaData.Request info, ByteBuffer header2, ByteBuffer chunk2, ByteBuffer content, boolean last) throws IOException {
        switch (this._state) {
            case START: {
                if (info == null) {
                    return Result.NEED_INFO;
                }
                if (header2 == null) {
                    return Result.NEED_HEADER;
                }
                int pos = BufferUtil.flipToFill(header2);
                try {
                    this.generateRequestLine(info, header2);
                    if (info.getHttpVersion() == HttpVersion.HTTP_0_9) {
                        throw new BadMessageException(500, "HTTP/0.9 not supported");
                    }
                    this.generateHeaders(info, header2, content, last);
                    boolean expect100 = info.getFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (expect100) {
                        this._state = State.COMMITTED;
                    } else {
                        int len = BufferUtil.length(content);
                        if (len > 0) {
                            this._contentPrepared += (long)len;
                            if (this.isChunking()) {
                                this.prepareChunk(header2, len);
                            }
                        }
                        this._state = last ? State.COMPLETING : State.COMMITTED;
                    }
                    Result result = Result.FLUSH;
                    return result;
                }
                catch (BadMessageException e2) {
                    throw e2;
                }
                catch (BufferOverflowException e3) {
                    LOG.ignore(e3);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception e4) {
                    throw new BadMessageException(500, e4.getMessage(), e4);
                }
                finally {
                    BufferUtil.flipToFlush(header2, pos);
                }
            }
            case COMMITTED: {
                return this.committed(chunk2, content, last);
            }
            case COMPLETING: {
                return this.completing(chunk2, content);
            }
            case END: {
                if (BufferUtil.hasContent(content)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(content);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private Result committed(ByteBuffer chunk2, ByteBuffer content, boolean last) {
        int len = BufferUtil.length(content);
        if (len > 0) {
            if (this.isChunking()) {
                if (chunk2 == null) {
                    return Result.NEED_CHUNK;
                }
                BufferUtil.clearToFill(chunk2);
                this.prepareChunk(chunk2, len);
                BufferUtil.flipToFlush(chunk2, 0);
            }
            this._contentPrepared += (long)len;
        }
        if (last) {
            this._state = State.COMPLETING;
            return len > 0 ? Result.FLUSH : Result.CONTINUE;
        }
        return len > 0 ? Result.FLUSH : Result.DONE;
    }

    private Result completing(ByteBuffer chunk2, ByteBuffer content) {
        if (BufferUtil.hasContent(content)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discarding content in COMPLETING", new Object[0]);
            }
            BufferUtil.clear(content);
        }
        if (this.isChunking()) {
            if (this._trailers != null) {
                if (chunk2 == null || chunk2.capacity() <= 12) {
                    return Result.NEED_CHUNK_TRAILER;
                }
                HttpFields trailers = this._trailers.get();
                if (trailers != null) {
                    BufferUtil.clearToFill(chunk2);
                    this.generateTrailers(chunk2, trailers);
                    BufferUtil.flipToFlush(chunk2, 0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
            }
            if (chunk2 == null) {
                return Result.NEED_CHUNK;
            }
            BufferUtil.clearToFill(chunk2);
            this.prepareChunk(chunk2, 0);
            BufferUtil.flipToFlush(chunk2, 0);
            this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
            return Result.FLUSH;
        }
        this._state = State.END;
        return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
    }

    @Deprecated
    public Result generateResponse(MetaData.Response info, ByteBuffer header2, ByteBuffer chunk2, ByteBuffer content, boolean last) throws IOException {
        return this.generateResponse(info, false, header2, chunk2, content, last);
    }

    public Result generateResponse(MetaData.Response info, boolean head2, ByteBuffer header2, ByteBuffer chunk2, ByteBuffer content, boolean last) throws IOException {
        switch (this._state) {
            case START: {
                if (info == null) {
                    return Result.NEED_INFO;
                }
                HttpVersion version = info.getHttpVersion();
                if (version == null) {
                    throw new BadMessageException(500, "No version");
                }
                if (version == HttpVersion.HTTP_0_9) {
                    this._persistent = false;
                    this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                    if (BufferUtil.hasContent(content)) {
                        this._contentPrepared += (long)content.remaining();
                    }
                    this._state = last ? State.COMPLETING : State.COMMITTED;
                    return Result.FLUSH;
                }
                if (header2 == null) {
                    return Result.NEED_HEADER;
                }
                int pos = BufferUtil.flipToFill(header2);
                try {
                    this.generateResponseLine(info, header2);
                    int status2 = info.getStatus();
                    if (status2 >= 100 && status2 < 200) {
                        this._noContentResponse = true;
                        if (status2 != 101) {
                            header2.put(HttpTokens.CRLF);
                            this._state = State.COMPLETING_1XX;
                            Result result = Result.FLUSH;
                            return result;
                        }
                    } else if (status2 == 204 || status2 == 304) {
                        this._noContentResponse = true;
                    }
                    this.generateHeaders(info, header2, content, last);
                    int len = BufferUtil.length(content);
                    if (len > 0) {
                        this._contentPrepared += (long)len;
                        if (this.isChunking() && !head2) {
                            this.prepareChunk(header2, len);
                        }
                    }
                    this._state = last ? State.COMPLETING : State.COMMITTED;
                }
                catch (BadMessageException e2) {
                    throw e2;
                }
                catch (BufferOverflowException e3) {
                    LOG.ignore(e3);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception e4) {
                    throw new BadMessageException(500, e4.getMessage(), e4);
                }
                finally {
                    BufferUtil.flipToFlush(header2, pos);
                }
                return Result.FLUSH;
            }
            case COMMITTED: {
                return this.committed(chunk2, content, last);
            }
            case COMPLETING_1XX: {
                this.reset();
                return Result.DONE;
            }
            case COMPLETING: {
                return this.completing(chunk2, content);
            }
            case END: {
                if (BufferUtil.hasContent(content)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(content);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private void prepareChunk(ByteBuffer chunk2, int remaining) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(chunk2);
        }
        if (remaining > 0) {
            BufferUtil.putHexInt(chunk2, remaining);
            BufferUtil.putCRLF(chunk2);
            this._needCRLF = true;
        } else {
            chunk2.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateTrailers(ByteBuffer buffer, HttpFields trailer) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(buffer);
        }
        buffer.put(ZERO_CHUNK);
        int n = trailer.size();
        for (int f = 0; f < n; ++f) {
            HttpField field = trailer.getField(f);
            HttpGenerator.putTo(field, buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    private void generateRequestLine(MetaData.Request request2, ByteBuffer header2) {
        header2.put(StringUtil.getBytes(request2.getMethod()));
        header2.put((byte)32);
        header2.put(StringUtil.getBytes(request2.getURIString()));
        header2.put((byte)32);
        header2.put(request2.getHttpVersion().toBytes());
        header2.put(HttpTokens.CRLF);
    }

    private void generateResponseLine(MetaData.Response response2, ByteBuffer header2) {
        int status2 = response2.getStatus();
        PreparedResponse preprepared = status2 < __preprepared.length ? __preprepared[status2] : null;
        String reason = response2.getReason();
        if (preprepared != null) {
            if (reason == null) {
                header2.put(preprepared._responseLine);
            } else {
                header2.put(preprepared._schemeCode);
                header2.put(this.getReasonBytes(reason));
                header2.put(HttpTokens.CRLF);
            }
        } else {
            header2.put(HTTP_1_1_SPACE);
            header2.put((byte)(48 + status2 / 100));
            header2.put((byte)(48 + status2 % 100 / 10));
            header2.put((byte)(48 + status2 % 10));
            header2.put((byte)32);
            if (reason == null) {
                header2.put((byte)(48 + status2 / 100));
                header2.put((byte)(48 + status2 % 100 / 10));
                header2.put((byte)(48 + status2 % 10));
            } else {
                header2.put(this.getReasonBytes(reason));
            }
            header2.put(HttpTokens.CRLF);
        }
    }

    private byte[] getReasonBytes(String reason) {
        if (reason.length() > 1024) {
            reason = reason.substring(0, 1024);
        }
        byte[] bytes2 = StringUtil.getBytes(reason);
        int i = bytes2.length;
        while (i-- > 0) {
            if (bytes2[i] != 13 && bytes2[i] != 10) continue;
            bytes2[i] = 63;
        }
        return bytes2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(MetaData info, ByteBuffer header2, ByteBuffer content, boolean last) {
        int status2;
        boolean nocontentRequest;
        MetaData.Response response2;
        MetaData.Request request2 = info instanceof MetaData.Request ? (MetaData.Request)info : null;
        MetaData.Response response3 = response2 = info instanceof MetaData.Response ? (MetaData.Response)info : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateHeaders {} last={} content={}", info, last, BufferUtil.toDetailString(content));
            LOG.debug(info.getFields().toString(), new Object[0]);
        }
        int send2 = this._send;
        HttpField transferEncoding = null;
        boolean http11 = info.getHttpVersion() == HttpVersion.HTTP_1_1;
        boolean close = false;
        this._trailers = http11 ? info.getTrailerSupplier() : null;
        boolean chunkedHint = this._trailers != null;
        boolean contentType = false;
        long contentLength = info.getContentLength();
        boolean contentLengthField = false;
        HttpFields fields = info.getFields();
        if (fields != null) {
            int n = fields.size();
            block7: for (int f = 0; f < n; ++f) {
                HttpField field = fields.getField(f);
                HttpHeader h = field.getHeader();
                if (h == null) {
                    HttpGenerator.putTo(field, header2);
                    continue;
                }
                switch (h) {
                    case CONTENT_LENGTH: {
                        if (contentLength < 0L) {
                            contentLength = field.getLongValue();
                        } else if (contentLength != field.getLongValue()) {
                            throw new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, field.getLongValue()));
                        }
                        contentLengthField = true;
                        continue block7;
                    }
                    case CONTENT_TYPE: {
                        contentType = true;
                        HttpGenerator.putTo(field, header2);
                        continue block7;
                    }
                    case TRANSFER_ENCODING: {
                        if (!http11) continue block7;
                        transferEncoding = field;
                        chunkedHint = field.contains(HttpHeaderValue.CHUNKED.asString());
                        continue block7;
                    }
                    case CONNECTION: {
                        boolean keepAlive = field.contains(HttpHeaderValue.KEEP_ALIVE.asString());
                        if (keepAlive && info.getHttpVersion() == HttpVersion.HTTP_1_0 && this._persistent == null) {
                            this._persistent = true;
                        }
                        if (field.contains(HttpHeaderValue.CLOSE.asString())) {
                            close = true;
                            this._persistent = false;
                        }
                        if (keepAlive && Boolean.FALSE.equals(this._persistent)) {
                            field = new HttpField(HttpHeader.CONNECTION, Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is((String)s)).collect(Collectors.joining(", ")));
                        }
                        HttpGenerator.putTo(field, header2);
                        continue block7;
                    }
                    case SERVER: {
                        send2 &= 0xFFFFFFFE;
                        HttpGenerator.putTo(field, header2);
                        continue block7;
                    }
                    default: {
                        HttpGenerator.putTo(field, header2);
                    }
                }
            }
        }
        if (last && contentLength < 0L && this._trailers == null) {
            contentLength = this._contentPrepared + (long)BufferUtil.length(content);
        }
        boolean assumedContentRequest = request2 != null && Boolean.TRUE.equals(ASSUMED_CONTENT_METHODS.get(request2.getMethod()));
        boolean assumedContent = assumedContentRequest || contentType || chunkedHint;
        boolean bl = nocontentRequest = request2 != null && contentLength <= 0L && !assumedContent;
        if (this._persistent == null) {
            this._persistent = http11 || request2 != null && HttpMethod.CONNECT.is(request2.getMethod());
        }
        if (this._noContentResponse || nocontentRequest) {
            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
            if (this._contentPrepared > 0L) {
                throw new BadMessageException(500, "Content for no content response");
            }
            if (contentLengthField) {
                if (response2 != null && response2.getStatus() == 304) {
                    HttpGenerator.putContentLength(header2, contentLength);
                } else if (contentLength > 0L) {
                    if (this._contentPrepared != 0L || !last) throw new BadMessageException(500, "Content for no content response");
                    content.clear();
                }
            }
        } else if (http11 && (chunkedHint || contentLength < 0L && (this._persistent.booleanValue() || assumedContentRequest))) {
            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
            if (transferEncoding == null) {
                header2.put(TRANSFER_ENCODING_CHUNKED);
            } else if (transferEncoding.toString().endsWith(HttpHeaderValue.CHUNKED.toString())) {
                HttpGenerator.putTo(transferEncoding, header2);
                transferEncoding = null;
            } else {
                if (chunkedHint) throw new BadMessageException(500, "Bad Transfer-Encoding");
                HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, transferEncoding.getValue() + ",chunked"), header2);
                transferEncoding = null;
            }
        } else if (contentLength >= 0L && (request2 != null || this._persistent.booleanValue())) {
            this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
            HttpGenerator.putContentLength(header2, contentLength);
        } else {
            if (response2 == null) throw new BadMessageException(500, "Unknown content length for request");
            this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
            this._persistent = false;
            if (contentLength >= 0L && (contentLength > 0L || assumedContent || contentLengthField)) {
                HttpGenerator.putContentLength(header2, contentLength);
            }
            if (http11 && !close) {
                header2.put(CONNECTION_CLOSE);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._endOfContent.toString(), new Object[0]);
        }
        if (transferEncoding != null) {
            if (chunkedHint) {
                String v = transferEncoding.getValue();
                int c = v.lastIndexOf(44);
                if (c > 0 && v.lastIndexOf(HttpHeaderValue.CHUNKED.toString(), c) > c) {
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, v.substring(0, c).trim()), header2);
                }
            } else {
                HttpGenerator.putTo(transferEncoding, header2);
            }
        }
        int n = status2 = response2 != null ? response2.getStatus() : -1;
        if (status2 > 199) {
            header2.put(SEND[send2]);
        }
        header2.put(HttpTokens.CRLF);
    }

    private static void putContentLength(ByteBuffer header2, long contentLength) {
        if (contentLength == 0L) {
            header2.put(CONTENT_LENGTH_0);
        } else {
            header2.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
            BufferUtil.putDecLong(header2, contentLength);
            header2.put(HttpTokens.CRLF);
        }
    }

    public static byte[] getReasonBuffer(int code2) {
        PreparedResponse status2;
        PreparedResponse preparedResponse = status2 = code2 < __preprepared.length ? __preprepared[code2] : null;
        if (status2 != null) {
            return status2._reason;
        }
        return null;
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String s, ByteBuffer buffer) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n' || c == ':') {
                buffer.put((byte)63);
                continue;
            }
            buffer.put((byte)(0xFF & c));
        }
    }

    private static void putSanitisedValue(String s, ByteBuffer buffer) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n') {
                buffer.put((byte)32);
                continue;
            }
            buffer.put((byte)(0xFF & c));
        }
    }

    public static void putTo(HttpField field, ByteBuffer bufferInFillMode) {
        if (field instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)field).putTo(bufferInFillMode, HttpVersion.HTTP_1_0);
        } else {
            HttpHeader header2 = field.getHeader();
            if (header2 != null) {
                bufferInFillMode.put(header2.getBytesColonSpace());
                HttpGenerator.putSanitisedValue(field.getValue(), bufferInFillMode);
            } else {
                HttpGenerator.putSanitisedName(field.getName(), bufferInFillMode);
                bufferInFillMode.put(__colon_space);
                HttpGenerator.putSanitisedValue(field.getValue(), bufferInFillMode);
            }
            BufferUtil.putCRLF(bufferInFillMode);
        }
    }

    public static void putTo(HttpFields fields, ByteBuffer bufferInFillMode) {
        for (HttpField field : fields) {
            if (field == null) continue;
            HttpGenerator.putTo(field, bufferInFillMode);
        }
        BufferUtil.putCRLF(bufferInFillMode);
    }

    static {
        ASSUMED_CONTENT_METHODS.put(HttpMethod.POST.asString(), Boolean.TRUE);
        ASSUMED_CONTENT_METHODS.put(HttpMethod.PUT.asString(), Boolean.TRUE);
        ZERO_CHUNK = new byte[]{48, 13, 10};
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes("Content-Length: 0\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes("Connection: close\r\n");
        HTTP_1_1_SPACE = StringUtil.getBytes((Object)((Object)HttpVersion.HTTP_1_1) + " ");
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes("Transfer-Encoding: chunked\r\n");
        SEND = new byte[][]{new byte[0], StringUtil.getBytes("Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes("X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes("Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
        __preprepared = new PreparedResponse[512];
        int versionLength = HttpVersion.HTTP_1_1.toString().length();
        for (int i = 0; i < __preprepared.length; ++i) {
            HttpStatus.Code code2 = HttpStatus.getCode(i);
            if (code2 == null) continue;
            String reason = code2.getMessage();
            byte[] line = new byte[versionLength + 5 + reason.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(line, 0, versionLength);
            line[versionLength + 0] = 32;
            line[versionLength + 1] = (byte)(48 + i / 100);
            line[versionLength + 2] = (byte)(48 + i % 100 / 10);
            line[versionLength + 3] = (byte)(48 + i % 10);
            line[versionLength + 4] = 32;
            for (int j = 0; j < reason.length(); ++j) {
                line[versionLength + 5 + j] = (byte)reason.charAt(j);
            }
            line[versionLength + 5 + reason.length()] = 13;
            line[versionLength + 6 + reason.length()] = 10;
            HttpGenerator.__preprepared[i] = new PreparedResponse();
            HttpGenerator.__preprepared[i]._schemeCode = Arrays.copyOfRange(line, 0, versionLength + 5);
            HttpGenerator.__preprepared[i]._reason = Arrays.copyOfRange(line, versionLength + 5, line.length - 2);
            HttpGenerator.__preprepared[i]._responseLine = line;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        HEADER_OVERFLOW,
        NEED_CHUNK_TRAILER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

