/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;

@Deprecated
public class PathMap<O>
extends HashMap<String, O> {
    private static String __pathSpecSeparators = ":,";
    Trie<MappedEntry<O>> _prefixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
    Trie<MappedEntry<O>> _suffixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
    final Map<String, MappedEntry<O>> _exactMap = new HashMap<String, MappedEntry<O>>();
    List<MappedEntry<O>> _defaultSingletonList = null;
    MappedEntry<O> _prefixDefault = null;
    MappedEntry<O> _default = null;
    boolean _nodefault = false;

    public static void setPathSpecSeparators(String s) {
        __pathSpecSeparators = s;
    }

    public PathMap() {
        this(11);
    }

    public PathMap(boolean noDefault) {
        this(11, noDefault);
    }

    public PathMap(int capacity) {
        this(capacity, false);
    }

    private PathMap(int capacity, boolean noDefault) {
        super(capacity);
        this._nodefault = noDefault;
    }

    public PathMap(Map<String, ? extends O> dictMap) {
        this.putAll(dictMap);
    }

    @Override
    public O put(String pathSpec, O object) {
        if ("".equals(pathSpec.trim())) {
            MappedEntry<O> entry2 = new MappedEntry<O>("", object);
            entry2.setMapped("");
            this._exactMap.put("", entry2);
            return super.put("", object);
        }
        StringTokenizer tok = new StringTokenizer(pathSpec, __pathSpecSeparators);
        O old = null;
        while (tok.hasMoreTokens()) {
            String spec2 = tok.nextToken();
            if (!spec2.startsWith("/") && !spec2.startsWith("*.")) {
                throw new IllegalArgumentException("PathSpec " + spec2 + ". must start with '/' or '*.'");
            }
            old = super.put(spec2, object);
            MappedEntry<O> entry3 = new MappedEntry<O>(spec2, object);
            if (!entry3.getKey().equals(spec2)) continue;
            if (spec2.equals("/*")) {
                this._prefixDefault = entry3;
                continue;
            }
            if (spec2.endsWith("/*")) {
                String mapped = spec2.substring(0, spec2.length() - 2);
                entry3.setMapped(mapped);
                while (!this._prefixMap.put(mapped, entry3)) {
                    this._prefixMap = new ArrayTernaryTrie<MappedEntry<O>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                }
                continue;
            }
            if (spec2.startsWith("*.")) {
                String suffix = spec2.substring(2);
                while (!this._suffixMap.put(suffix, entry3)) {
                    this._suffixMap = new ArrayTernaryTrie<MappedEntry<O>>((ArrayTernaryTrie)this._suffixMap, 1.5);
                }
                continue;
            }
            if (spec2.equals("/")) {
                if (this._nodefault) {
                    this._exactMap.put(spec2, entry3);
                    continue;
                }
                this._default = entry3;
                this._defaultSingletonList = Collections.singletonList(this._default);
                continue;
            }
            entry3.setMapped(spec2);
            this._exactMap.put(spec2, entry3);
        }
        return old;
    }

    public O match(String path2) {
        MappedEntry<O> entry2 = this.getMatch(path2);
        if (entry2 != null) {
            return entry2.getValue();
        }
        return null;
    }

    public MappedEntry<O> getMatch(String path2) {
        if (path2 == null) {
            return null;
        }
        int l = path2.length();
        MappedEntry<O> entry2 = null;
        if (l == 1 && path2.charAt(0) == '/' && (entry2 = this._exactMap.get("")) != null) {
            return entry2;
        }
        entry2 = this._exactMap.get(path2);
        if (entry2 != null) {
            return entry2;
        }
        int i = l;
        Trie<MappedEntry<O>> prefix_map = this._prefixMap;
        while (i >= 0 && (entry2 = prefix_map.getBest(path2, 0, i)) != null) {
            String key2 = entry2.getKey();
            if (key2.length() - 2 >= path2.length() || path2.charAt(key2.length() - 2) == '/') {
                return entry2;
            }
            i = key2.length() - 3;
        }
        if (this._prefixDefault != null) {
            return this._prefixDefault;
        }
        i = 0;
        Trie<MappedEntry<O>> suffix_map = this._suffixMap;
        while ((i = path2.indexOf(46, i + 1)) > 0) {
            entry2 = suffix_map.get(path2, i + 1, l - i - 1);
            if (entry2 == null) continue;
            return entry2;
        }
        return this._default;
    }

    public List<? extends Map.Entry<String, O>> getMatches(String path2) {
        int l;
        ArrayList<MappedEntry<O>> entries = new ArrayList<MappedEntry<O>>();
        if (path2 == null) {
            return entries;
        }
        if (path2.isEmpty()) {
            return this._defaultSingletonList;
        }
        MappedEntry<O> entry2 = this._exactMap.get(path2);
        if (entry2 != null) {
            entries.add(entry2);
        }
        int i = l = path2.length();
        Trie<MappedEntry<O>> prefix_map = this._prefixMap;
        while (i >= 0 && (entry2 = prefix_map.getBest(path2, 0, i)) != null) {
            String key2 = entry2.getKey();
            if (key2.length() - 2 >= path2.length() || path2.charAt(key2.length() - 2) == '/') {
                entries.add(entry2);
            }
            i = key2.length() - 3;
        }
        if (this._prefixDefault != null) {
            entries.add(this._prefixDefault);
        }
        i = 0;
        Trie<MappedEntry<O>> suffix_map = this._suffixMap;
        while ((i = path2.indexOf(46, i + 1)) > 0) {
            entry2 = suffix_map.get(path2, i + 1, l - i - 1);
            if (entry2 == null) continue;
            entries.add(entry2);
        }
        if ("/".equals(path2) && (entry2 = this._exactMap.get("")) != null) {
            entries.add(entry2);
        }
        if (this._default != null) {
            entries.add(this._default);
        }
        return entries;
    }

    public boolean containsMatch(String path2) {
        MappedEntry<O> match = this.getMatch(path2);
        return match != null && !match.equals(this._default);
    }

    @Override
    public O remove(Object pathSpec) {
        if (pathSpec != null) {
            String spec2 = (String)pathSpec;
            if (spec2.equals("/*")) {
                this._prefixDefault = null;
            } else if (spec2.endsWith("/*")) {
                this._prefixMap.remove(spec2.substring(0, spec2.length() - 2));
            } else if (spec2.startsWith("*.")) {
                this._suffixMap.remove(spec2.substring(2));
            } else if (spec2.equals("/")) {
                this._default = null;
                this._defaultSingletonList = null;
            } else {
                this._exactMap.remove(spec2);
            }
        }
        return (O)super.remove(pathSpec);
    }

    @Override
    public void clear() {
        this._exactMap.clear();
        this._prefixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
        this._suffixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
        this._default = null;
        this._defaultSingletonList = null;
        this._prefixDefault = null;
        super.clear();
    }

    public static boolean match(String pathSpec, String path2) {
        return PathMap.match(pathSpec, path2, false);
    }

    public static boolean match(String pathSpec, String path2, boolean noDefault) {
        if (pathSpec.isEmpty()) {
            return "/".equals(path2);
        }
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (!noDefault && pathSpec.length() == 1 || pathSpec.equals(path2)) {
                return true;
            }
            return PathMap.isPathWildcardMatch(pathSpec, path2);
        }
        if (c == '*') {
            return path2.regionMatches(path2.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    private static boolean isPathWildcardMatch(String pathSpec, String path2) {
        int cpl = pathSpec.length() - 2;
        if (pathSpec.endsWith("/*") && path2.regionMatches(0, pathSpec, 0, cpl)) {
            return path2.length() == cpl || '/' == path2.charAt(cpl);
        }
        return false;
    }

    public static String pathMatch(String pathSpec, String path2) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return path2;
            }
            if (pathSpec.equals(path2)) {
                return path2;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path2)) {
                return path2.substring(0, pathSpec.length() - 2);
            }
        } else if (c == '*' && path2.regionMatches(path2.length() - (pathSpec.length() - 1), pathSpec, 1, pathSpec.length() - 1)) {
            return path2;
        }
        return null;
    }

    public static String pathInfo(String pathSpec, String path2) {
        if ("".equals(pathSpec)) {
            return path2;
        }
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return null;
            }
            boolean wildcard = PathMap.isPathWildcardMatch(pathSpec, path2);
            if (pathSpec.equals(path2) && !wildcard) {
                return null;
            }
            if (wildcard) {
                if (path2.length() == pathSpec.length() - 2) {
                    return null;
                }
                return path2.substring(pathSpec.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String base, String pathSpec, String path2) {
        String info = PathMap.pathInfo(pathSpec, path2);
        if (info == null) {
            info = path2;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path2 = base.endsWith("/") ? (info.startsWith("/") ? base + info.substring(1) : base + info) : (info.startsWith("/") ? base + info : base + "/" + info);
        return path2;
    }

    public static class PathSet
    extends AbstractSet<String>
    implements Predicate<String> {
        private final PathMap<Boolean> _map = new PathMap();

        @Override
        public Iterator<String> iterator() {
            return this._map.keySet().iterator();
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public boolean add(String item) {
            return this._map.put(item, Boolean.TRUE) == null;
        }

        @Override
        public boolean remove(Object item) {
            return this._map.remove(item) != null;
        }

        @Override
        public boolean contains(Object o) {
            return this._map.containsKey(o);
        }

        @Override
        public boolean test(String s) {
            return this._map.containsMatch(s);
        }

        public boolean containsMatch(String s) {
            return this._map.containsMatch(s);
        }
    }

    public static class MappedEntry<O>
    implements Map.Entry<String, O> {
        private final String key;
        private final O value;
        private String mapped;

        MappedEntry(String key2, O value) {
            this.key = key2;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public O getValue() {
            return this.value;
        }

        @Override
        public O setValue(O o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public String getMapped() {
            return this.mapped;
        }

        void setMapped(String mapped) {
            this.mapped = mapped;
        }
    }
}

