/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;

public class Iso88591HttpWriter
extends HttpWriter {
    public Iso88591HttpWriter(HttpOutput out) {
        super(out);
    }

    @Override
    public void write(char[] s, int offset, int length) throws IOException {
        HttpOutput out = this._out;
        if (length == 1) {
            int c = s[offset];
            out.write(c < 256 ? c : 63);
            return;
        }
        while (length > 0) {
            this._bytes.reset();
            int chars2 = Math.min(length, 512);
            byte[] buffer = this._bytes.getBuf();
            int bytes2 = this._bytes.getCount();
            if (chars2 > buffer.length - bytes2) {
                chars2 = buffer.length - bytes2;
            }
            for (int i = 0; i < chars2; ++i) {
                int c = s[offset + i];
                buffer[bytes2++] = (byte)(c < 256 ? c : 63);
            }
            if (bytes2 >= 0) {
                this._bytes.setCount(bytes2);
            }
            this._bytes.writeTo(out);
            length -= chars2;
            offset += chars2;
        }
    }
}

