/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.ContentFactory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final CompressedContentFormat[] _precompressedFormats;

    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, CompressedContentFormat[] precompressedFormats) {
        this._factory = factory;
        this._mimeTypes = mimeTypes;
        this._precompressedFormats = precompressedFormats;
    }

    @Override
    public HttpContent getContent(String pathInContext, int maxBufferSize) throws IOException {
        try {
            Resource resource2 = this._factory.getResource(pathInContext);
            HttpContent loaded = this.load(pathInContext, resource2, maxBufferSize);
            return loaded;
        }
        catch (Throwable t) {
            throw (InvalidPathException)new InvalidPathException(pathInContext, "Invalid PathInContext").initCause(t);
        }
    }

    private HttpContent load(String pathInContext, Resource resource2, int maxBufferSize) throws IOException {
        if (resource2 == null || !resource2.exists()) {
            return null;
        }
        if (resource2.isDirectory()) {
            return new ResourceHttpContent(resource2, this._mimeTypes.getMimeByExtension(resource2.toString()), maxBufferSize);
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._precompressedFormats.length > 0) {
            HashMap<CompressedContentFormat, HttpContent> compressedContents = new HashMap<CompressedContentFormat, HttpContent>(this._precompressedFormats.length);
            for (CompressedContentFormat format2 : this._precompressedFormats) {
                String compressedPathInContext = pathInContext + format2.getExtension();
                Resource compressedResource = this._factory.getResource(compressedPathInContext);
                if (compressedResource == null || !compressedResource.exists() || compressedResource.lastModified() < resource2.lastModified() || compressedResource.length() >= resource2.length()) continue;
                compressedContents.put(format2, new ResourceHttpContent(compressedResource, this._mimeTypes.getMimeByExtension(compressedPathInContext), maxBufferSize));
            }
            if (!compressedContents.isEmpty()) {
                return new ResourceHttpContent(resource2, mt, maxBufferSize, compressedContents);
            }
        }
        return new ResourceHttpContent(resource2, mt, maxBufferSize);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

