/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.resource.HttpContentRangeWriter;
import org.eclipse.jetty.server.resource.RangeWriter;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Invocable;

public class ResourceService {
    private static final Logger LOG = Log.getLogger(ResourceService.class);
    private static final PreEncodedHttpField ACCEPT_RANGES = new PreEncodedHttpField(HttpHeader.ACCEPT_RANGES, "bytes");
    private HttpContent.ContentFactory _contentFactory;
    private WelcomeFactory _welcomeFactory;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _redirectWelcome = false;
    private CompressedContentFormat[] _precompressedFormats = new CompressedContentFormat[0];
    private String[] _preferredEncodingOrder = new String[0];
    private final Map<String, List<String>> _preferredEncodingOrderCache = new ConcurrentHashMap<String, List<String>>();
    private int _encodingCacheSize = 100;
    private boolean _pathInfoOnly = false;
    private boolean _etags = false;
    private HttpField _cacheControl;
    private List<String> _gzipEquivalentFileExtensions;

    public HttpContent.ContentFactory getContentFactory() {
        return this._contentFactory;
    }

    public void setContentFactory(HttpContent.ContentFactory contentFactory) {
        this._contentFactory = contentFactory;
    }

    public WelcomeFactory getWelcomeFactory() {
        return this._welcomeFactory;
    }

    public void setWelcomeFactory(WelcomeFactory welcomeFactory) {
        this._welcomeFactory = welcomeFactory;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._acceptRanges = acceptRanges;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._dirAllowed = dirAllowed;
    }

    public boolean isRedirectWelcome() {
        return this._redirectWelcome;
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._redirectWelcome = redirectWelcome;
    }

    public CompressedContentFormat[] getPrecompressedFormats() {
        return this._precompressedFormats;
    }

    public void setPrecompressedFormats(CompressedContentFormat[] precompressedFormats) {
        this._precompressedFormats = precompressedFormats;
        this._preferredEncodingOrder = (String[])Arrays.stream(this._precompressedFormats).map(f -> f.getEncoding()).toArray(String[]::new);
    }

    public void setEncodingCacheSize(int encodingCacheSize) {
        this._encodingCacheSize = encodingCacheSize;
    }

    public int getEncodingCacheSize() {
        return this._encodingCacheSize;
    }

    public boolean isPathInfoOnly() {
        return this._pathInfoOnly;
    }

    public void setPathInfoOnly(boolean pathInfoOnly) {
        this._pathInfoOnly = pathInfoOnly;
    }

    public boolean isEtags() {
        return this._etags;
    }

    public void setEtags(boolean etags) {
        this._etags = etags;
    }

    public HttpField getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(HttpField cacheControl) {
        if (cacheControl == null) {
            this._cacheControl = null;
        }
        if (cacheControl.getHeader() != HttpHeader.CACHE_CONTROL) {
            throw new IllegalArgumentException("!Cache-Control");
        }
        this._cacheControl = cacheControl instanceof PreEncodedHttpField ? cacheControl : new PreEncodedHttpField(cacheControl.getHeader(), cacheControl.getValue());
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._gzipEquivalentFileExtensions;
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._gzipEquivalentFileExtensions = gzipEquivalentFileExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doGet(HttpServletRequest request2, HttpServletResponse response2) throws ServletException, IOException {
        boolean included;
        String servletPath = null;
        String pathInfo = null;
        Enumeration<String> reqRanges = null;
        boolean bl = included = request2.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            servletPath = this._pathInfoOnly ? "/" : (String)request2.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request2.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request2.getServletPath();
                pathInfo = request2.getPathInfo();
            }
        } else {
            servletPath = this._pathInfoOnly ? "/" : request2.getServletPath();
            pathInfo = request2.getPathInfo();
            reqRanges = request2.getHeaders(HttpHeader.RANGE.asString());
            if (!this.hasDefinedRange(reqRanges)) {
                reqRanges = null;
            }
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        boolean endsWithSlash = (pathInfo == null ? (this._pathInfoOnly ? "" : servletPath) : pathInfo).endsWith("/");
        boolean checkPrecompressedVariants = this._precompressedFormats.length > 0 && !endsWithSlash && !included && reqRanges == null;
        HttpContent content = null;
        boolean releaseContent = true;
        try {
            Map<CompressedContentFormat, ? extends HttpContent> precompressedContents;
            content = this._contentFactory.getContent(pathInContext, response2.getBufferSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug("content={}", content);
            }
            if (content == null || !content.getResource().exists()) {
                if (included) {
                    throw new FileNotFoundException("!" + pathInContext);
                }
                this.notFound(request2, response2);
                boolean bl2 = response2.isCommitted();
                return bl2;
            }
            if (content.getResource().isDirectory()) {
                this.sendWelcome(content, pathInContext, endsWithSlash, included, request2, response2);
                boolean bl3 = true;
                return bl3;
            }
            if (!included && endsWithSlash && pathInContext.length() > 1) {
                String q = request2.getQueryString();
                pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                if (q != null && q.length() != 0) {
                    pathInContext = pathInContext + "?" + q;
                }
                response2.sendRedirect(response2.encodeRedirectURL(URIUtil.addPaths(request2.getContextPath(), pathInContext)));
                boolean bl4 = true;
                return bl4;
            }
            if (!included && !this.passConditionalHeaders(request2, response2, content)) {
                boolean q = true;
                return q;
            }
            Map<CompressedContentFormat, ? extends HttpContent> map2 = precompressedContents = checkPrecompressedVariants ? content.getPrecompressedContents() : null;
            if (precompressedContents != null && precompressedContents.size() > 0) {
                response2.addHeader(HttpHeader.VARY.asString(), HttpHeader.ACCEPT_ENCODING.asString());
                List<String> preferredEncodings = this.getPreferredEncodingOrder(request2);
                CompressedContentFormat precompressedContentEncoding = this.getBestPrecompressedContent(preferredEncodings, precompressedContents.keySet());
                if (precompressedContentEncoding != null) {
                    HttpContent precompressedContent = precompressedContents.get(precompressedContentEncoding);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("precompressed={}", precompressedContent);
                    }
                    content = precompressedContent;
                    response2.setHeader(HttpHeader.CONTENT_ENCODING.asString(), precompressedContentEncoding.getEncoding());
                }
            }
            if (this.isGzippedContent(pathInContext)) {
                response2.setHeader(HttpHeader.CONTENT_ENCODING.asString(), "gzip");
            }
            releaseContent = this.sendData(request2, response2, included, content, reqRanges);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("EXCEPTION ", e2);
            if (!response2.isCommitted()) {
                response2.sendError(500, e2.getMessage());
            }
        }
        finally {
            if (releaseContent && content != null) {
                content.release();
            }
        }
        return true;
    }

    private List<String> getPreferredEncodingOrder(HttpServletRequest request2) {
        List<String> values;
        Enumeration<String> headers = request2.getHeaders(HttpHeader.ACCEPT_ENCODING.asString());
        if (!headers.hasMoreElements()) {
            return Collections.emptyList();
        }
        String key2 = headers.nextElement();
        if (headers.hasMoreElements()) {
            StringBuilder sb = new StringBuilder(key2.length() * 2);
            sb.append(key2);
            do {
                sb.append(',').append(headers.nextElement());
            } while (headers.hasMoreElements());
            key2 = sb.toString();
        }
        if ((values = this._preferredEncodingOrderCache.get(key2)) == null) {
            QuotedQualityCSV encodingQualityCSV = new QuotedQualityCSV(this._preferredEncodingOrder);
            encodingQualityCSV.addValue(key2);
            values = encodingQualityCSV.getValues();
            if (this._preferredEncodingOrderCache.size() > this._encodingCacheSize) {
                this._preferredEncodingOrderCache.clear();
            }
            this._preferredEncodingOrderCache.put(key2, values);
        }
        return values;
    }

    private CompressedContentFormat getBestPrecompressedContent(List<String> preferredEncodings, Collection<CompressedContentFormat> availableFormats) {
        if (availableFormats.isEmpty()) {
            return null;
        }
        for (String encoding2 : preferredEncodings) {
            for (CompressedContentFormat format2 : availableFormats) {
                if (!format2.getEncoding().equals(encoding2)) continue;
                return format2;
            }
            if ("*".equals(encoding2)) {
                return availableFormats.iterator().next();
            }
            if (!HttpHeaderValue.IDENTITY.asString().equals(encoding2)) continue;
            return null;
        }
        return null;
    }

    protected void sendWelcome(HttpContent content, String pathInContext, boolean endsWithSlash, boolean included, HttpServletRequest request2, HttpServletResponse response2) throws ServletException, IOException {
        String welcome;
        if (!endsWithSlash) {
            StringBuilder buf = new StringBuilder(request2.getRequestURI());
            int param = buf.lastIndexOf(";");
            if (param < 0 || buf.lastIndexOf("/", param) > 0) {
                buf.append('/');
            } else {
                buf.insert(param, '/');
            }
            String q = request2.getQueryString();
            if (q != null && q.length() != 0) {
                buf.append('?');
                buf.append(q);
            }
            response2.setContentLength(0);
            response2.sendRedirect(response2.encodeRedirectURL(buf.toString()));
            return;
        }
        String string2 = welcome = this._welcomeFactory == null ? null : this._welcomeFactory.getWelcomeFile(pathInContext);
        if (welcome != null) {
            String servletPath;
            String string3 = servletPath = included ? (String)request2.getAttribute("javax.servlet.include.servlet_path") : request2.getServletPath();
            if (this._pathInfoOnly) {
                welcome = URIUtil.addPaths(servletPath, welcome);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("welcome={}", welcome);
            }
            ServletContext context2 = request2.getServletContext();
            if (this._redirectWelcome || context2 == null) {
                response2.setContentLength(0);
                String uri = URIUtil.encodePath(URIUtil.addPaths(request2.getContextPath(), welcome));
                String q = request2.getQueryString();
                if (q != null && !q.isEmpty()) {
                    uri = uri + "?" + q;
                }
                response2.sendRedirect(response2.encodeRedirectURL(uri));
                return;
            }
            RequestDispatcher dispatcher = context2.getRequestDispatcher(URIUtil.encodePath(welcome));
            if (dispatcher != null) {
                if (included) {
                    dispatcher.include(request2, response2);
                } else {
                    request2.setAttribute("org.eclipse.jetty.server.welcome", welcome);
                    dispatcher.forward(request2, response2);
                }
            }
            return;
        }
        if (included || this.passConditionalHeaders(request2, response2, content)) {
            this.sendDirectory(request2, response2, content.getResource(), pathInContext);
        }
    }

    protected boolean isGzippedContent(String path2) {
        if (path2 == null || this._gzipEquivalentFileExtensions == null) {
            return false;
        }
        for (String suffix : this._gzipEquivalentFileExtensions) {
            if (!path2.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefinedRange(Enumeration<String> reqRanges) {
        return reqRanges != null && reqRanges.hasMoreElements();
    }

    protected void notFound(HttpServletRequest request2, HttpServletResponse response2) throws IOException {
        response2.sendError(404);
    }

    protected void sendStatus(HttpServletResponse response2, int status2, Supplier<String> etag) throws IOException {
        response2.setStatus(status2);
        if (this._etags && etag != null) {
            response2.setHeader(HttpHeader.ETAG.asString(), etag.get());
        }
        response2.flushBuffer();
    }

    protected boolean passConditionalHeaders(HttpServletRequest request2, HttpServletResponse response2, HttpContent content) throws IOException {
        try {
            String ifm = null;
            String ifnm = null;
            String ifms = null;
            long ifums = -1L;
            if (request2 instanceof Request) {
                HttpFields fields = ((Request)request2).getHttpFields();
                int i = fields.size();
                while (i-- > 0) {
                    HttpField field = fields.getField(i);
                    if (field.getHeader() == null) continue;
                    switch (field.getHeader()) {
                        case IF_MATCH: {
                            ifm = field.getValue();
                            break;
                        }
                        case IF_NONE_MATCH: {
                            ifnm = field.getValue();
                            break;
                        }
                        case IF_MODIFIED_SINCE: {
                            ifms = field.getValue();
                            break;
                        }
                        case IF_UNMODIFIED_SINCE: {
                            ifums = DateParser.parseDate(field.getValue());
                            break;
                        }
                    }
                }
            } else {
                ifm = request2.getHeader(HttpHeader.IF_MATCH.asString());
                ifnm = request2.getHeader(HttpHeader.IF_NONE_MATCH.asString());
                ifms = request2.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                ifums = request2.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
            }
            if (this._etags) {
                String etag = content.getETagValue();
                if (ifm != null) {
                    boolean match = false;
                    if (etag != null) {
                        QuotedCSV quoted = new QuotedCSV(true, ifm);
                        for (String etagWithSuffix : quoted) {
                            if (!CompressedContentFormat.tagEquals(etag, etagWithSuffix)) continue;
                            match = true;
                            break;
                        }
                    }
                    if (!match) {
                        this.sendStatus(response2, 412, null);
                        return false;
                    }
                }
                if (ifnm != null && etag != null) {
                    if (CompressedContentFormat.tagEquals(etag, ifnm) && ifnm.indexOf(44) < 0) {
                        this.sendStatus(response2, 304, ifnm::toString);
                        return false;
                    }
                    QuotedCSV quoted = new QuotedCSV(true, ifnm);
                    for (String tag : quoted) {
                        if (!CompressedContentFormat.tagEquals(etag, tag)) continue;
                        this.sendStatus(response2, 304, tag::toString);
                        return false;
                    }
                    return true;
                }
            }
            if (ifms != null) {
                String mdlm = content.getLastModifiedValue();
                if (ifms.equals(mdlm)) {
                    this.sendStatus(response2, 304, content::getETagValue);
                    return false;
                }
                long ifmsl = request2.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                if (ifmsl != -1L && content.getResource().lastModified() / 1000L <= ifmsl / 1000L) {
                    this.sendStatus(response2, 304, content::getETagValue);
                    return false;
                }
            }
            if (ifums != -1L && content.getResource().lastModified() / 1000L > ifums / 1000L) {
                response2.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response2.isCommitted()) {
                response2.sendError(400, iae.getMessage());
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request2, HttpServletResponse response2, Resource resource2, String pathInContext) throws IOException {
        if (!this._dirAllowed) {
            response2.sendError(403);
            return;
        }
        byte[] data2 = null;
        String base = URIUtil.addEncodedPaths(request2.getRequestURI(), "/");
        String dir2 = resource2.getListHTML(base, pathInContext.length() > 1, request2.getQueryString());
        if (dir2 == null) {
            response2.sendError(403, "No directory");
            return;
        }
        data2 = dir2.getBytes(StandardCharsets.UTF_8);
        response2.setContentType("text/html;charset=utf-8");
        response2.setContentLength(data2.length);
        response2.getOutputStream().write(data2);
    }

    protected boolean sendData(HttpServletRequest request2, HttpServletResponse response2, boolean include, final HttpContent content, Enumeration<String> reqRanges) throws IOException {
        boolean written;
        OutputStream out;
        long content_length2 = content.getContentLengthValue();
        try {
            out = response2.getOutputStream();
            written = !(out instanceof HttpOutput) || ((HttpOutput)out).isWritten();
        }
        catch (IllegalStateException e2) {
            out = new WriterOutputStream(response2.getWriter());
            written = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("sendData content=%s out=%s async=%b", content, out, request2.isAsyncSupported()), new Object[0]);
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length2 < 0L) {
            if (include) {
                content.getResource().writeTo(out, 0L, content_length2);
            } else if (written) {
                this.putHeaders(response2, content, -1L);
                ByteBuffer buffer = content.getIndirectBuffer();
                if (buffer != null) {
                    BufferUtil.writeTo(buffer, out);
                } else {
                    content.getResource().writeTo(out, 0L, content_length2);
                }
            } else {
                this.putHeaders(response2, content, -2L);
                if (request2.isAsyncSupported()) {
                    final AsyncContext context2 = request2.startAsync();
                    context2.setTimeout(0L);
                    ((HttpOutput)out).sendContent(content, new Callback(){

                        @Override
                        public void succeeded() {
                            context2.complete();
                            content.release();
                        }

                        @Override
                        public void failed(Throwable x) {
                            if (x instanceof IOException) {
                                LOG.debug(x);
                            } else {
                                LOG.warn(x);
                            }
                            context2.complete();
                            content.release();
                        }

                        @Override
                        public Invocable.InvocationType getInvocationType() {
                            return Invocable.InvocationType.NON_BLOCKING;
                        }

                        public String toString() {
                            return String.format("ResourceService@%x$CB", ResourceService.this.hashCode());
                        }
                    });
                    return false;
                }
                ((HttpOutput)out).sendContent(content);
            }
        } else {
            List<InclusiveByteRange> ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length2);
            if (ranges == null || ranges.size() == 0) {
                this.putHeaders(response2, content, -2L);
                response2.setHeader(HttpHeader.CONTENT_RANGE.asString(), InclusiveByteRange.to416HeaderRangeString(content_length2));
                this.sendStatus(response2, 416, null);
                return true;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = ranges.iterator().next();
                long singleLength = singleSatisfiableRange.getSize();
                this.putHeaders(response2, content, singleLength);
                response2.setStatus(206);
                if (!response2.containsHeader(HttpHeader.DATE.asString())) {
                    response2.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
                }
                response2.setHeader(HttpHeader.CONTENT_RANGE.asString(), singleSatisfiableRange.toHeaderRangeString(content_length2));
                content.getResource().writeTo(out, singleSatisfiableRange.getFirst(), singleLength);
                return true;
            }
            this.putHeaders(response2, content, -1L);
            String mimetype = content.getContentTypeValue();
            if (mimetype == null) {
                LOG.warn("Unknown mimetype for " + request2.getRequestURI(), new Object[0]);
            }
            MultiPartOutputStream multi = new MultiPartOutputStream(out);
            response2.setStatus(206);
            if (!response2.containsHeader(HttpHeader.DATE.asString())) {
                response2.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
            }
            String ctp = request2.getHeader(HttpHeader.REQUEST_RANGE.asString()) != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response2.setContentType(ctp + multi.getBoundary());
            int length = 0;
            String[] header2 = new String[ranges.size()];
            int i = 0;
            int CRLF = "\r\n".length();
            int DASHDASH = "--".length();
            int BOUNDARY = multi.getBoundary().length();
            int FIELD_SEP = ": ".length();
            for (InclusiveByteRange ibr : ranges) {
                header2[i] = ibr.toHeaderRangeString(content_length2);
                if (i > 0) {
                    length += CRLF;
                }
                length += DASHDASH + BOUNDARY + CRLF;
                if (mimetype != null) {
                    length += HttpHeader.CONTENT_TYPE.asString().length() + FIELD_SEP + mimetype.length() + CRLF;
                }
                length += HttpHeader.CONTENT_RANGE.asString().length() + FIELD_SEP + header2[i].length() + CRLF;
                length += CRLF;
                length = (int)((long)length + ibr.getSize());
                ++i;
            }
            response2.setContentLength(length += CRLF + DASHDASH + BOUNDARY + DASHDASH + CRLF);
            try (RangeWriter rangeWriter = HttpContentRangeWriter.newRangeWriter(content);){
                i = 0;
                for (InclusiveByteRange ibr : ranges) {
                    multi.startPart(mimetype, new String[]{(Object)((Object)HttpHeader.CONTENT_RANGE) + ": " + header2[i]});
                    rangeWriter.writeTo(multi, ibr.getFirst(), ibr.getSize());
                    ++i;
                }
            }
            multi.close();
        }
        return true;
    }

    protected void putHeaders(HttpServletResponse response2, HttpContent content, long contentLength) {
        if (response2 instanceof Response) {
            Response r = (Response)response2;
            r.putHeaders(content, contentLength, this._etags);
            HttpFields fields = r.getHttpFields();
            if (this._acceptRanges && !fields.contains(HttpHeader.ACCEPT_RANGES)) {
                fields.add(ACCEPT_RANGES);
            }
            if (this._cacheControl != null && !fields.contains(HttpHeader.CACHE_CONTROL)) {
                fields.add(this._cacheControl);
            }
        } else {
            Response.putHeaders(response2, content, contentLength, this._etags);
            if (this._acceptRanges && !response2.containsHeader(HttpHeader.ACCEPT_RANGES.asString())) {
                response2.setHeader(ACCEPT_RANGES.getName(), ACCEPT_RANGES.getValue());
            }
            if (this._cacheControl != null && !response2.containsHeader(HttpHeader.CACHE_CONTROL.asString())) {
                response2.setHeader(this._cacheControl.getName(), this._cacheControl.getValue());
            }
        }
    }

    public static interface WelcomeFactory {
        public String getWelcomeFile(String var1);
    }
}

