/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;

public class Utf8HttpWriter
extends HttpWriter {
    int _surrogate = 0;

    public Utf8HttpWriter(HttpOutput out) {
        super(out);
    }

    @Override
    public void write(char[] s, int offset, int length) throws IOException {
        HttpOutput out = this._out;
        while (length > 0) {
            this._bytes.reset();
            int chars2 = Math.min(length, 512);
            byte[] buffer = this._bytes.getBuf();
            int bytes2 = this._bytes.getCount();
            if (bytes2 + chars2 > buffer.length) {
                chars2 = buffer.length - bytes2;
            }
            for (int i = 0; i < chars2; ++i) {
                int code2 = s[offset + i];
                if (this._surrogate == 0) {
                    if (Character.isHighSurrogate((char)code2)) {
                        this._surrogate = code2;
                        continue;
                    }
                } else if (Character.isLowSurrogate((char)code2)) {
                    code2 = Character.toCodePoint((char)this._surrogate, (char)code2);
                } else {
                    code2 = this._surrogate;
                    this._surrogate = 0;
                    --i;
                }
                if ((code2 & 0xFFFFFF80) == 0) {
                    if (bytes2 >= buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)code2;
                    continue;
                }
                if ((code2 & 0xFFFFF800) == 0) {
                    if (bytes2 + 2 > buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)(0xC0 | code2 >> 6);
                    buffer[bytes2++] = (byte)(0x80 | code2 & 0x3F);
                } else if ((code2 & 0xFFFF0000) == 0) {
                    if (bytes2 + 3 > buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)(0xE0 | code2 >> 12);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 6 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 & 0x3F);
                } else if ((code2 & 0xFF200000) == 0) {
                    if (bytes2 + 4 > buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)(0xF0 | code2 >> 18);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 12 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 6 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 & 0x3F);
                } else if ((code2 & 0xF4000000) == 0) {
                    if (bytes2 + 5 > buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)(0xF8 | code2 >> 24);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 18 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 12 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 6 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 & 0x3F);
                } else if ((code2 & Integer.MIN_VALUE) == 0) {
                    if (bytes2 + 6 > buffer.length) {
                        chars2 = i;
                        break;
                    }
                    buffer[bytes2++] = (byte)(0xFC | code2 >> 30);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 24 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 18 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 12 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 >> 6 & 0x3F);
                    buffer[bytes2++] = (byte)(0x80 | code2 & 0x3F);
                } else {
                    buffer[bytes2++] = 63;
                }
                this._surrogate = 0;
                if (bytes2 != buffer.length) continue;
                chars2 = i + 1;
                break;
            }
            this._bytes.setCount(bytes2);
            this._bytes.writeTo(out);
            length -= chars2;
            offset += chars2;
        }
    }
}

