/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class DefaultHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DefaultHandler.class);
    final long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    final byte[] _favicon;
    boolean _serveIcon = true;
    boolean _showContexts = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultHandler() {
        byte[] favbytes = null;
        try {
            URL fav = this.getClass().getClassLoader().getResource("org/eclipse/jetty/favicon.ico");
            if (fav != null) {
                Resource r = Resource.newResource(fav);
                favbytes = IO.readBytes(r.getInputStream());
            }
        }
        catch (Exception e2) {
            LOG.warn(e2);
        }
        finally {
            this._favicon = favbytes;
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException, ServletException {
        if (response2.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request2.getMethod();
        if (this._serveIcon && this._favicon != null && HttpMethod.GET.is(method) && target.equals("/favicon.ico")) {
            if (request2.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this._faviconModified) {
                response2.setStatus(304);
            } else {
                response2.setStatus(200);
                response2.setContentType("image/x-icon");
                response2.setContentLength(this._favicon.length);
                response2.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this._faviconModified);
                response2.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
                response2.getOutputStream().write(this._favicon);
            }
            return;
        }
        if (!(this._showContexts && HttpMethod.GET.is(method) && request2.getRequestURI().equals("/"))) {
            response2.sendError(404);
            return;
        }
        response2.setStatus(404);
        response2.setContentType(MimeTypes.Type.TEXT_HTML_UTF_8.toString());
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
            writer2.append("<!DOCTYPE html>\n");
            writer2.append("<html lang=\"en\">\n<head>\n");
            writer2.append("<title>Error 404 - Not Found</title>\n");
            writer2.append("<meta charset=\"utf-8\">\n");
            writer2.append("<style>body { font-family: sans-serif; } table, td { border: 1px solid #333; } td, th { padding: 5px; } thead, tfoot { background-color: #333; color: #fff; } </style>\n");
            writer2.append("</head>\n<body>\n");
            writer2.append("<h2>Error 404 - Not Found.</h2>\n");
            writer2.append("<p>No context on this server matched or handled this request.</p>\n");
            writer2.append("<p>Contexts known to this server are:</p>\n");
            Server server2 = this.getServer();
            Handler[] handlers = server2 == null ? null : server2.getChildHandlersByClass(ContextHandler.class);
            writer2.append("<table class=\"contexts\"><thead><tr>");
            writer2.append("<th>Context Path</th>");
            writer2.append("<th>Display Name</th>");
            writer2.append("<th>Status</th>");
            writer2.append("<th>LifeCycle</th>");
            writer2.append("</tr></thead><tbody>\n");
            for (int i = 0; handlers != null && i < handlers.length; ++i) {
                writer2.append("<tr><td>");
                ContextHandler context2 = (ContextHandler)handlers[i];
                String contextPath = context2.getContextPath();
                String href2 = URIUtil.encodePath(contextPath);
                if (contextPath.length() > 1 && !contextPath.endsWith("/")) {
                    href2 = href2 + '/';
                }
                if (context2.isRunning()) {
                    writer2.append("<a href=\"").append(href2).append("\">");
                }
                writer2.append(StringUtil.replace(contextPath, "%", "&#37;"));
                if (context2.isRunning()) {
                    writer2.append("</a>");
                }
                writer2.append("</td><td>");
                if (StringUtil.isNotBlank(context2.getDisplayName())) {
                    writer2.append(StringUtil.sanitizeXmlString(context2.getDisplayName()));
                }
                writer2.append("&nbsp;</td><td>");
                if (context2.isAvailable()) {
                    writer2.append("Available");
                } else {
                    writer2.append("<em>Not</em> Available");
                }
                writer2.append("</td><td>");
                writer2.append(context2.getState());
                writer2.append("</td></tr>\n");
            }
            writer2.append("</tbody></table><hr/>\n");
            writer2.append("<a href=\"https://eclipse.org/jetty\"><img alt=\"icon\" src=\"/favicon.ico\"/></a>&nbsp;");
            writer2.append("<a href=\"https://eclipse.org/jetty\">Powered by Eclipse Jetty:// Server</a><hr/>\n");
            writer2.append("</body>\n</html>\n");
            writer2.flush();
            byte[] content = outputStream.toByteArray();
            response2.setContentLength(content.length);
            try (ServletOutputStream out = response2.getOutputStream();){
                out.write(content);
            }
        }
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    public void setServeIcon(boolean serveIcon) {
        this._serveIcon = serveIcon;
    }

    public boolean getShowContexts() {
        return this._showContexts;
    }

    public void setShowContexts(boolean show) {
        this._showContexts = show;
    }
}

