/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.io.ByteBufferOutputStream;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    public static final String ERROR_CONTEXT = "org.eclipse.jetty.server.error_context";
    public static final String ERROR_CHARSET = "org.eclipse.jetty.server.error_charset";
    boolean _showServlet = true;
    boolean _showStacks = true;
    boolean _disableStacks = false;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    public boolean errorPageForMethod(String method) {
        switch (method) {
            case "GET": 
            case "POST": 
            case "HEAD": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException, ServletException {
        this.doError(target, baseRequest, request2, response2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doError(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException {
        block11: {
            String cacheControl = this.getCacheControl();
            if (cacheControl != null) {
                response2.setHeader(HttpHeader.CACHE_CONTROL.asString(), cacheControl);
            }
            String errorPage = this instanceof ErrorPageMapper ? ((ErrorPageMapper)((Object)this)).getErrorPage(request2) : null;
            ContextHandler.Context context2 = baseRequest.getErrorContext();
            Dispatcher errorDispatcher = errorPage != null && context2 != null ? (Dispatcher)context2.getRequestDispatcher(errorPage) : null;
            try {
                String message;
                block10: {
                    if (errorDispatcher != null) {
                        try {
                            errorDispatcher.error(request2, response2);
                            return;
                        }
                        catch (ServletException e2) {
                            LOG.debug(e2);
                            if (!response2.isCommitted()) break block10;
                            baseRequest.setHandled(true);
                            return;
                        }
                    }
                }
                if ((message = (String)request2.getAttribute("javax.servlet.error.message")) == null) {
                    message = baseRequest.getResponse().getReason();
                }
                this.generateAcceptableResponse(baseRequest, request2, response2, response2.getStatus(), message);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                baseRequest.setHandled(true);
            }
        }
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request2, HttpServletResponse response2, int code2, String message) throws IOException {
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT, QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        if (acceptable.isEmpty() && !baseRequest.getHttpFields().contains(HttpHeader.ACCEPT)) {
            this.generateAcceptableResponse(baseRequest, request2, response2, code2, message, MimeTypes.Type.TEXT_HTML.asString());
        } else {
            for (String mimeType : acceptable) {
                this.generateAcceptableResponse(baseRequest, request2, response2, code2, message, mimeType);
                if (!response2.isCommitted() && !baseRequest.getResponse().isWritingOrStreaming()) continue;
                break;
            }
        }
    }

    @Deprecated
    protected Writer getAcceptableWriter(Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException {
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (acceptable.isEmpty()) {
            response2.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
            return response2.getWriter();
        }
        for (String charset2 : acceptable) {
            try {
                if ("*".equals(charset2)) {
                    response2.setCharacterEncoding(StandardCharsets.UTF_8.name());
                } else {
                    response2.setCharacterEncoding(Charset.forName(charset2).name());
                }
                return response2.getWriter();
            }
            catch (Exception e2) {
                LOG.ignore(e2);
            }
        }
        return null;
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request2, HttpServletResponse response2, int code2, String message, String contentType) throws IOException {
        MimeTypes.Type type2;
        Charset charset2 = null;
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (!acceptable.isEmpty()) {
            for (String name2 : acceptable) {
                if ("*".equals(name2)) {
                    charset2 = StandardCharsets.UTF_8;
                    break;
                }
                try {
                    charset2 = Charset.forName(name2);
                }
                catch (Exception e2) {
                    LOG.ignore(e2);
                }
            }
            if (charset2 == null) {
                return;
            }
        }
        switch (contentType) {
            case "text/html": 
            case "text/*": 
            case "*/*": {
                type2 = MimeTypes.Type.TEXT_HTML;
                if (charset2 != null) break;
                charset2 = StandardCharsets.ISO_8859_1;
                break;
            }
            case "text/json": 
            case "application/json": {
                type2 = MimeTypes.Type.TEXT_JSON;
                if (charset2 != null) break;
                charset2 = StandardCharsets.UTF_8;
                break;
            }
            case "text/plain": {
                type2 = MimeTypes.Type.TEXT_PLAIN;
                if (charset2 != null) break;
                charset2 = StandardCharsets.ISO_8859_1;
                break;
            }
            default: {
                return;
            }
        }
        while (true) {
            try {
                ByteBuffer buffer = baseRequest.getResponse().getHttpOutput().getBuffer();
                ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
                PrintWriter writer2 = new PrintWriter(new OutputStreamWriter((OutputStream)out, charset2));
                switch (type2) {
                    case TEXT_HTML: {
                        response2.setContentType(MimeTypes.Type.TEXT_HTML.asString());
                        response2.setCharacterEncoding(charset2.name());
                        request2.setAttribute(ERROR_CHARSET, charset2);
                        this.handleErrorPage(request2, writer2, code2, message);
                        break;
                    }
                    case TEXT_JSON: {
                        response2.setContentType(contentType);
                        this.writeErrorJson(request2, writer2, code2, message);
                        break;
                    }
                    case TEXT_PLAIN: {
                        response2.setContentType(MimeTypes.Type.TEXT_PLAIN.asString());
                        response2.setCharacterEncoding(charset2.name());
                        this.writeErrorPlain(request2, writer2, code2, message);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                writer2.flush();
            }
            catch (BufferOverflowException e3) {
                LOG.warn("Error page too large: {} {} {}", code2, message, request2);
                if (LOG.isDebugEnabled()) {
                    LOG.warn(e3);
                }
                baseRequest.getResponse().resetContent();
                if (this._disableStacks) break;
                LOG.info("Disabling showsStacks for " + this, new Object[0]);
                this._disableStacks = true;
                continue;
            }
            break;
        }
        baseRequest.getHttpChannel().sendResponseAndComplete();
    }

    protected void handleErrorPage(HttpServletRequest request2, Writer writer2, int code2, String message) throws IOException {
        this.writeErrorPage(request2, writer2, code2, message, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest request2, Writer writer2, int code2, String message, boolean showStacks) throws IOException {
        if (message == null) {
            message = HttpStatus.getMessage(code2);
        }
        writer2.write("<html>\n<head>\n");
        this.writeErrorPageHead(request2, writer2, code2, message);
        writer2.write("</head>\n<body>");
        this.writeErrorPageBody(request2, writer2, code2, message, showStacks);
        writer2.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest request2, Writer writer2, int code2, String message) throws IOException {
        Charset charset2 = (Charset)request2.getAttribute(ERROR_CHARSET);
        if (charset2 != null) {
            writer2.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=");
            writer2.write(charset2.name());
            writer2.write("\"/>\n");
        }
        writer2.write("<title>Error ");
        String status2 = Integer.toString(code2);
        writer2.write(status2);
        if (message != null && !message.equals(status2)) {
            writer2.write(32);
            writer2.write(StringUtil.sanitizeXmlString(message));
        }
        writer2.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest request2, Writer writer2, int code2, String message, boolean showStacks) throws IOException {
        String uri = request2.getRequestURI();
        this.writeErrorPageMessage(request2, writer2, code2, message, uri);
        if (showStacks && !this._disableStacks) {
            this.writeErrorPageStacks(request2, writer2);
        }
        Request.getBaseRequest(request2).getHttpChannel().getHttpConfiguration().writePoweredBy(writer2, "<hr/>", "<hr/>\n");
    }

    protected void writeErrorPageMessage(HttpServletRequest request2, Writer writer2, int code2, String message, String uri) throws IOException {
        writer2.write("<h2>HTTP ERROR ");
        String status2 = Integer.toString(code2);
        writer2.write(status2);
        if (message != null && !message.equals(status2)) {
            writer2.write(32);
            writer2.write(StringUtil.sanitizeXmlString(message));
        }
        writer2.write("</h2>\n");
        writer2.write("<table>\n");
        this.htmlRow(writer2, "URI", uri);
        this.htmlRow(writer2, "STATUS", status2);
        this.htmlRow(writer2, "MESSAGE", message);
        if (this.isShowServlet()) {
            this.htmlRow(writer2, "SERVLET", request2.getAttribute("javax.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request2.getAttribute("javax.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            this.htmlRow(writer2, "CAUSED BY", cause);
        }
        writer2.write("</table>\n");
    }

    private void htmlRow(Writer writer2, String tag, Object value) throws IOException {
        writer2.write("<tr><th>");
        writer2.write(tag);
        writer2.write(":</th><td>");
        if (value == null) {
            writer2.write("-");
        } else {
            writer2.write(StringUtil.sanitizeXmlString(value.toString()));
        }
        writer2.write("</td></tr>\n");
    }

    private void writeErrorPlain(HttpServletRequest request2, PrintWriter writer2, int code2, String message) {
        writer2.write("HTTP ERROR ");
        writer2.write(Integer.toString(code2));
        writer2.write(32);
        writer2.write(StringUtil.sanitizeXmlString(message));
        writer2.write("\n");
        writer2.printf("URI: %s%n", request2.getRequestURI());
        writer2.printf("STATUS: %s%n", code2);
        writer2.printf("MESSAGE: %s%n", message);
        if (this.isShowServlet()) {
            writer2.printf("SERVLET: %s%n", request2.getAttribute("javax.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request2.getAttribute("javax.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            writer2.printf("CAUSED BY %s%n", cause);
            if (!this.isShowStacks() || this._disableStacks) continue;
            cause.printStackTrace(writer2);
        }
    }

    private void writeErrorJson(HttpServletRequest request2, PrintWriter writer2, int code2, String message) {
        Throwable cause = (Throwable)request2.getAttribute("javax.servlet.error.exception");
        Object servlet2 = request2.getAttribute("javax.servlet.error.servlet_name");
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("url", request2.getRequestURI());
        json.put("status", Integer.toString(code2));
        json.put("message", message);
        if (this.isShowServlet() && servlet2 != null) {
            json.put("servlet", servlet2.toString());
        }
        int c = 0;
        while (cause != null) {
            json.put("cause" + c++, cause.toString());
            cause = cause.getCause();
        }
        writer2.append(json.entrySet().stream().map(e2 -> QuotedStringTokenizer.quote((String)e2.getKey()) + ":" + QuotedStringTokenizer.quote(StringUtil.sanitizeXmlString((String)e2.getValue()))).collect(Collectors.joining(",\n", "{\n", "\n}")));
    }

    protected void writeErrorPageStacks(HttpServletRequest request2, Writer writer2) throws IOException {
        Throwable th = (Throwable)request2.getAttribute("javax.servlet.error.exception");
        if (th != null) {
            writer2.write("<h3>Caused by:</h3><pre>");
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
                pw.flush();
                this.write(writer2, sw.getBuffer().toString());
            }
            writer2.write("</pre>\n");
        }
    }

    public ByteBuffer badMessageError(int status2, String reason, HttpFields fields) {
        if (reason == null) {
            reason = HttpStatus.getMessage(status2);
        }
        fields.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML_8859_1.asString());
        return BufferUtil.toBuffer("<h1>Bad Message " + status2 + "</h1><pre>reason: " + reason + "</pre>");
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl;
    }

    public boolean isShowServlet() {
        return this._showServlet;
    }

    public void setShowServlet(boolean showServlet) {
        this._showServlet = showServlet;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this._showStacks = showStacks;
    }

    public void setShowMessageInTitle(boolean showMessageInTitle) {
        this._showMessageInTitle = showMessageInTitle;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    protected void write(Writer writer2, String string2) throws IOException {
        if (string2 == null) {
            return;
        }
        writer2.write(StringUtil.sanitizeXmlString(string2));
    }

    public static ErrorHandler getErrorHandler(Server server2, ContextHandler context2) {
        ErrorHandler errorHandler = null;
        if (context2 != null) {
            errorHandler = context2.getErrorHandler();
        }
        if (errorHandler == null && server2 != null) {
            errorHandler = server2.getBean(ErrorHandler.class);
        }
        return errorHandler;
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

