/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IPAddressMap;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class IPAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(IPAccessHandler.class);
    PathMap<IPAddressMap<Boolean>> _white = new PathMap(true);
    PathMap<IPAddressMap<Boolean>> _black = new PathMap(true);
    boolean _whiteListByPath = false;

    public IPAccessHandler() {
    }

    public IPAccessHandler(String[] white, String[] black) {
        if (white != null && white.length > 0) {
            this.setWhite(white);
        }
        if (black != null && black.length > 0) {
            this.setBlack(black);
        }
    }

    public void addWhite(String entry2) {
        this.add(entry2, this._white);
    }

    public void addBlack(String entry2) {
        this.add(entry2, this._black);
    }

    public void setWhite(String[] entries) {
        this.set(entries, this._white);
    }

    public void setBlack(String[] entries) {
        this.set(entries, this._black);
    }

    public void setWhiteListByPath(boolean whiteListByPath) {
        this._whiteListByPath = whiteListByPath;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException, ServletException {
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAddrUriAllowed(address.getHostString(), baseRequest.getMetaData().getURI().getDecodedPath())) {
            response2.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request2, response2);
    }

    protected void add(String entry2, PathMap<IPAddressMap<Boolean>> patternMap) {
        if (entry2 != null && entry2.length() > 0) {
            IPAddressMap<Boolean> addrMap;
            String path2;
            int idx;
            boolean deprecated = false;
            if (entry2.indexOf(124) > 0) {
                idx = entry2.indexOf(124);
            } else {
                idx = entry2.indexOf(47);
                deprecated = idx >= 0;
            }
            String addr = idx > 0 ? entry2.substring(0, idx) : entry2;
            String string2 = path2 = idx > 0 ? entry2.substring(idx) : "/*";
            if (addr.endsWith(".")) {
                deprecated = true;
            }
            if (path2 != null && (path2.startsWith("|") || path2.startsWith("/*."))) {
                path2 = path2.substring(1);
            }
            if ((addrMap = (IPAddressMap<Boolean>)patternMap.get(path2)) == null) {
                addrMap = new IPAddressMap<Boolean>();
                patternMap.put(path2, addrMap);
            }
            if (addr != null && !"".equals(addr)) {
                addrMap.put(addr, true);
            }
            if (deprecated) {
                LOG.debug(this.toString() + " - deprecated specification syntax: " + entry2, new Object[0]);
            }
        }
    }

    protected void set(String[] entries, PathMap<IPAddressMap<Boolean>> patternMap) {
        patternMap.clear();
        if (entries != null && entries.length > 0) {
            for (String addrPath : entries) {
                this.add(addrPath, patternMap);
            }
        }
    }

    protected boolean isAddrUriAllowed(String addr, String path2) {
        if (this._white.size() > 0) {
            boolean match = false;
            boolean matchedByPath = false;
            for (Map.Entry<String, IPAddressMap<Boolean>> entry2 : this._white.getMatches(path2)) {
                matchedByPath = true;
                IPAddressMap<Boolean> addrMap = entry2.getValue();
                if (addrMap == null || addrMap.size() != 0 && addrMap.match(addr) == null) continue;
                match = true;
                break;
            }
            if (this._whiteListByPath ? matchedByPath && !match : !match) {
                return false;
            }
        }
        if (this._black.size() > 0) {
            for (Map.Entry<String, IPAddressMap<Boolean>> entry3 : this._black.getMatches(path2)) {
                IPAddressMap<Boolean> addrMap = entry3.getValue();
                if (addrMap == null || addrMap.size() != 0 && addrMap.match(addr) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void dump(Appendable out, String indent2) throws IOException {
        this.dumpObjects(out, indent2, DumpableCollection.from("white", this._white), DumpableCollection.from("black", this._black), DumpableCollection.from("whiteListByPath", this._whiteListByPath));
    }
}

