/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ShutdownHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ShutdownHandler.class);
    private final String _shutdownToken;
    private boolean _sendShutdownAtStart;
    private boolean _exitJvm = false;

    @Deprecated
    public ShutdownHandler(Server server2, String shutdownToken) {
        this(shutdownToken);
    }

    public ShutdownHandler(String shutdownToken) {
        this(shutdownToken, false, false);
    }

    public ShutdownHandler(String shutdownToken, boolean exitJVM, boolean sendShutdownAtStart) {
        this._shutdownToken = shutdownToken;
        this.setExitJvm(exitJVM);
        this.setSendShutdownAtStart(sendShutdownAtStart);
    }

    public void sendShutdown() throws IOException {
        URL url2 = new URL(this.getServerUrl() + "/shutdown?token=" + this._shutdownToken);
        try {
            HttpURLConnection connection = (HttpURLConnection)url2.openConnection();
            connection.setRequestMethod("POST");
            connection.getResponseCode();
            LOG.info("Shutting down " + url2 + ": " + connection.getResponseCode() + " " + connection.getResponseMessage(), new Object[0]);
        }
        catch (SocketException e2) {
            LOG.debug("Not running", new Object[0]);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private String getServerUrl() {
        NetworkConnector connector = null;
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return "http://localhost";
        }
        return "http://localhost:" + connector.getPort();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._sendShutdownAtStart) {
            this.sendShutdown();
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response2) throws IOException, ServletException {
        if (!target.equals("/shutdown")) {
            super.handle(target, baseRequest, request2, response2);
            return;
        }
        if (!request2.getMethod().equals("POST")) {
            response2.sendError(400);
            return;
        }
        if (!this.hasCorrectSecurityToken(request2)) {
            LOG.warn("Unauthorized tokenless shutdown attempt from " + request2.getRemoteAddr(), new Object[0]);
            response2.sendError(401);
            return;
        }
        if (!this.requestFromLocalhost(baseRequest)) {
            LOG.warn("Unauthorized non-loopback shutdown attempt from " + request2.getRemoteAddr(), new Object[0]);
            response2.sendError(401);
            return;
        }
        LOG.info("Shutting down by request from " + request2.getRemoteAddr(), new Object[0]);
        this.doShutdown(baseRequest, response2);
    }

    protected void doShutdown(Request baseRequest, HttpServletResponse response2) throws IOException {
        for (Connector connector : this.getServer().getConnectors()) {
            connector.shutdown();
        }
        baseRequest.setHandled(true);
        response2.setStatus(200);
        response2.flushBuffer();
        final Server server2 = this.getServer();
        new Thread(){

            @Override
            public void run() {
                try {
                    ShutdownHandler.this.shutdownServer(server2);
                }
                catch (InterruptedException e2) {
                    LOG.ignore(e2);
                }
                catch (Exception e3) {
                    throw new RuntimeException("Shutting down server", e3);
                }
            }
        }.start();
    }

    private boolean requestFromLocalhost(Request request2) {
        InetSocketAddress addr = request2.getRemoteInetSocketAddress();
        if (addr == null) {
            return false;
        }
        return addr.getAddress().isLoopbackAddress();
    }

    private boolean hasCorrectSecurityToken(HttpServletRequest request2) {
        String tok = request2.getParameter("token");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Token: {}", tok);
        }
        return this._shutdownToken.equals(tok);
    }

    private void shutdownServer(Server server2) throws Exception {
        server2.stop();
        if (this._exitJvm) {
            System.exit(0);
        }
    }

    public void setExitJvm(boolean exitJvm) {
        this._exitJvm = exitJvm;
    }

    public boolean isSendShutdownAtStart() {
        return this._sendShutdownAtStart;
    }

    public void setSendShutdownAtStart(boolean sendShutdownAtStart) {
        this._sendShutdownAtStart = sendShutdownAtStart;
    }

    public String getShutdownToken() {
        return this._shutdownToken;
    }

    public boolean isExitJvm() {
        return this._exitJvm;
    }
}

