/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.io.IOException;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = Log.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            ContextHandler context2;
            AbstractHandler handler;
            Server server2;
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler handler2 = (ContextHandler)this._managed;
                String context3 = this.getContextName(handler2);
                if (context3 == null) {
                    context3 = handler2.getDisplayName();
                }
                if (context3 != null) {
                    return context3;
                }
            } else if (this._managed instanceof AbstractHandler && (server2 = (handler = (AbstractHandler)this._managed).getServer()) != null && (context2 = AbstractHandlerContainer.findContainerOf(server2, ContextHandler.class, handler)) != null) {
                basis = this.getContextName(context2);
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    protected String getContextName(ContextHandler context2) {
        String name2 = null;
        if (context2.getContextPath() != null && context2.getContextPath().length() > 0) {
            int idx = context2.getContextPath().lastIndexOf(47);
            String string2 = name2 = idx < 0 ? context2.getContextPath() : context2.getContextPath().substring(++idx);
            if (name2 == null || name2.length() == 0) {
                name2 = "ROOT";
            }
        }
        if (name2 == null && context2.getBaseResource() != null) {
            try {
                if (context2.getBaseResource().getFile() != null) {
                    name2 = context2.getBaseResource().getFile().getName();
                }
            }
            catch (IOException e2) {
                LOG.ignore(e2);
                name2 = context2.getBaseResource().getName();
            }
        }
        if (context2.getVirtualHosts() != null && context2.getVirtualHosts().length > 0) {
            name2 = '\"' + name2 + "@" + context2.getVirtualHosts()[0] + '\"';
        }
        return name2;
    }
}

