/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field> {
    private final boolean caseSensitive;
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    public Fields(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.fields = new LinkedHashMap<String, Field>();
    }

    public Fields(Fields original, boolean immutable) {
        this.caseSensitive = original.caseSensitive;
        LinkedHashMap<String, Field> copy2 = new LinkedHashMap<String, Field>();
        copy2.putAll(original.fields);
        this.fields = immutable ? Collections.unmodifiableMap(copy2) : copy2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fields that = (Fields)obj;
        if (this.getSize() != that.getSize()) {
            return false;
        }
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        for (Map.Entry<String, Field> entry2 : this.fields.entrySet()) {
            String name2 = entry2.getKey();
            Field value = entry2.getValue();
            if (value.equals(that.get(name2), this.caseSensitive)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Set<String> getNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Field field : this.fields.values()) {
            result.add(field.getName());
        }
        return result;
    }

    private String normalizeName(String name2) {
        return this.caseSensitive ? name2 : name2.toLowerCase(Locale.ENGLISH);
    }

    public Field get(String name2) {
        return this.fields.get(this.normalizeName(name2));
    }

    public void put(String name2, String value) {
        Field field = new Field(name2, value);
        this.fields.put(this.normalizeName(name2), field);
    }

    public void put(Field field) {
        if (field != null) {
            this.fields.put(this.normalizeName(field.getName()), field);
        }
    }

    public void add(String name2, String value) {
        String key2 = this.normalizeName(name2);
        Field field = this.fields.get(key2);
        if (field == null) {
            field = new Field(name2, value);
            this.fields.put(key2, field);
        } else {
            field = new Field(field.getName(), (List)field.getValues(), new String[]{value});
            this.fields.put(key2, field);
        }
    }

    public Field remove(String name2) {
        return this.fields.remove(this.normalizeName(name2));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public String toString() {
        return this.fields.toString();
    }

    public static class Field {
        private final String name;
        private final List<String> values;

        public Field(String name2, String value) {
            this(name2, Collections.singletonList(value), new String[0]);
        }

        private Field(String name2, List<String> values, String ... moreValues) {
            this.name = name2;
            ArrayList<String> list = new ArrayList<String>(values.size() + moreValues.length);
            list.addAll(values);
            list.addAll(Arrays.asList(moreValues));
            this.values = Collections.unmodifiableList(list);
        }

        public boolean equals(Field that, boolean caseSensitive) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (caseSensitive) {
                return this.equals(that);
            }
            return this.name.equalsIgnoreCase(that.name) && this.values.equals(that.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field that = (Field)obj;
            return this.name.equals(that.name) && this.values.equals(that.values);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.values.get(0);
        }

        public Integer getValueAsInt() {
            String value = this.getValue();
            return value == null ? null : Integer.valueOf(value);
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.size() > 1;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.values);
        }
    }
}

