/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.TypeUtil;

public class MultiReleaseJarFile
implements Closeable {
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private final JarFile jarFile;
    private final int platform;
    private final boolean multiRelease;
    private final Map<String, VersionedJarEntry> entries;

    public MultiReleaseJarFile(File file2) throws IOException {
        this(file2, JavaVersion.VERSION.getPlatform(), false);
    }

    public MultiReleaseJarFile(File file2, int javaPlatform, boolean includeDirectories) throws IOException {
        if (file2 == null || !file2.exists() || !file2.canRead() || file2.isDirectory()) {
            throw new IllegalArgumentException("bad jar file: " + file2);
        }
        this.jarFile = new JarFile(file2, true, 1);
        this.platform = javaPlatform;
        Manifest manifest = this.jarFile.getManifest();
        this.multiRelease = manifest == null ? false : Boolean.parseBoolean(String.valueOf(manifest.getMainAttributes().getValue("Multi-Release")));
        TreeMap map2 = new TreeMap();
        this.jarFile.stream().map(x$0 -> new VersionedJarEntry((JarEntry)x$0)).filter(e2 -> (includeDirectories || !e2.isDirectory()) && e2.isApplicable()).forEach(e2 -> map2.compute(e2.name, (k, v) -> v == null || v.isReplacedBy((VersionedJarEntry)e2) ? e2 : v));
        Iterator i = map2.entrySet().iterator();
        while (i.hasNext()) {
            VersionedJarEntry outer;
            Map.Entry e3 = i.next();
            VersionedJarEntry entry2 = (VersionedJarEntry)e3.getValue();
            if (!entry2.inner) continue;
            VersionedJarEntry versionedJarEntry = outer = entry2.outer == null ? null : (VersionedJarEntry)map2.get(entry2.outer);
            if (outer != null && outer.version == entry2.version) continue;
            i.remove();
        }
        this.entries = Collections.unmodifiableMap(map2);
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public int getVersion() {
        return this.platform;
    }

    public Stream<VersionedJarEntry> stream() {
        return this.entries.values().stream();
    }

    public VersionedJarEntry getEntry(String name2) {
        return this.entries.get(name2);
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public String toString() {
        return String.format("%s[%b,%d]", this.jarFile.getName(), this.isMultiRelease(), this.getVersion());
    }

    public class VersionedJarEntry {
        final JarEntry entry;
        final String name;
        final int version;
        final boolean inner;
        final String outer;

        VersionedJarEntry(JarEntry entry2) {
            int v = 0;
            String name2 = entry2.getName();
            if (name2.startsWith(MultiReleaseJarFile.META_INF_VERSIONS)) {
                v = -1;
                int index2 = name2.indexOf(47, MultiReleaseJarFile.META_INF_VERSIONS.length());
                if (index2 > MultiReleaseJarFile.META_INF_VERSIONS.length() && index2 < name2.length()) {
                    try {
                        v = TypeUtil.parseInt(name2, MultiReleaseJarFile.META_INF_VERSIONS.length(), index2 - MultiReleaseJarFile.META_INF_VERSIONS.length(), 10);
                        name2 = name2.substring(index2 + 1);
                    }
                    catch (NumberFormatException x) {
                        throw new RuntimeException("illegal version in " + MultiReleaseJarFile.this.jarFile, x);
                    }
                }
            }
            this.entry = entry2;
            this.name = name2;
            this.version = v;
            this.inner = name2.contains("$") && name2.toLowerCase(Locale.ENGLISH).endsWith(".class");
            this.outer = this.inner ? name2.substring(0, name2.indexOf(36)) + ".class" : null;
        }

        public String getName() {
            return this.name;
        }

        public String getNameInJar() {
            return this.entry.getName();
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isVersioned() {
            return this.version > 0;
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public InputStream getInputStream() throws IOException {
            return MultiReleaseJarFile.this.jarFile.getInputStream(this.entry);
        }

        boolean isApplicable() {
            if (MultiReleaseJarFile.this.multiRelease) {
                return (this.version == 0 || this.version == MultiReleaseJarFile.this.platform) && this.name.length() > 0;
            }
            return this.version == 0;
        }

        boolean isReplacedBy(VersionedJarEntry entry2) {
            if (this.isDirectory()) {
                return entry2.version == 0;
            }
            return this.name.equals(entry2.name) && entry2.version > this.version;
        }

        public String toString() {
            return String.format("%s->%s[%d]", this.name, this.entry.getName(), this.version);
        }
    }
}

