/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

@Deprecated
public class FileResource
extends Resource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private final File _file;
    private final URI _uri;
    private final URI _alias;

    public FileResource(URL url2) throws IOException, URISyntaxException {
        File file2;
        try {
            file2 = new File(url2.toURI());
            this.assertValidPath(file2.toString());
        }
        catch (URISyntaxException e2) {
            throw e2;
        }
        catch (Exception e3) {
            if (!url2.toString().startsWith("file:")) {
                throw new IllegalArgumentException("!file:");
            }
            LOG.ignore(e3);
            try {
                String fileUrl = "file:" + URIUtil.encodePath(url2.toString().substring(5));
                URI uri = new URI(fileUrl);
                file2 = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + URIUtil.decodePath(url2.getFile()));
            }
            catch (Exception ex2) {
                LOG.ignore(ex2);
                URLConnection connection = url2.openConnection();
                Permission perm = connection.getPermission();
                file2 = new File(perm == null ? url2.getFile() : perm.getName());
            }
        }
        this._file = file2;
        this._uri = FileResource.normalizeURI(this._file, url2.toURI());
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(URI uri) {
        File file2;
        this._file = file2 = new File(uri);
        try {
            URI fileUri = this._file.toURI();
            this._uri = FileResource.normalizeURI(this._file, uri);
            this.assertValidPath(file2.toString());
            this._alias = !URIUtil.equalsIgnoreEncodings(this._uri.toASCIIString(), fileUri.toString()) ? this._file.toURI() : FileResource.checkFileAlias(this._uri, this._file);
        }
        catch (URISyntaxException e2) {
            throw new InvalidPathException(this._file.toString(), e2.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e2);
                }
            };
        }
    }

    public FileResource(File file2) {
        this.assertValidPath(file2.toString());
        this._file = file2;
        try {
            this._uri = FileResource.normalizeURI(this._file, this._file.toURI());
        }
        catch (URISyntaxException e2) {
            throw new InvalidPathException(this._file.toString(), e2.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e2);
                }
            };
        }
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(File base, String childPath) {
        URI uri;
        String encoded = URIUtil.encodePath(childPath);
        this._file = new File(base, childPath);
        try {
            uri = base.isDirectory() ? new URI(URIUtil.addEncodedPaths(base.toURI().toASCIIString(), encoded)) : new URI(base.toURI().toASCIIString() + encoded);
        }
        catch (URISyntaxException e2) {
            throw new InvalidPathException(base.toString() + childPath, e2.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e2);
                }
            };
        }
        this._uri = uri;
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    @Override
    public boolean isSame(Resource resource2) {
        block4: {
            try {
                if (resource2 instanceof PathResource) {
                    Path path2 = ((PathResource)resource2).getPath();
                    return Files.isSameFile(this.getFile().toPath(), path2);
                }
                if (resource2 instanceof FileResource) {
                    Path path3 = ((FileResource)resource2).getFile().toPath();
                    return Files.isSameFile(this.getFile().toPath(), path3);
                }
            }
            catch (IOException e2) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", e2);
            }
        }
        return false;
    }

    private static URI normalizeURI(File file2, URI uri) throws URISyntaxException {
        String u = uri.toASCIIString();
        if (file2.isDirectory()) {
            if (!u.endsWith("/")) {
                u = u + "/";
            }
        } else if (file2.exists() && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        return new URI(u);
    }

    private static URI checkFileAlias(URI uri, File file2) {
        try {
            String can;
            if (!URIUtil.equalsIgnoreEncodings(uri, file2.toURI())) {
                return new File(uri).getAbsoluteFile().toURI();
            }
            String abs2 = file2.getAbsolutePath();
            if (!abs2.equals(can = file2.getCanonicalPath())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs={} can={}", abs2, can);
                }
                URI alias2 = new File(can).toURI();
                return new URI("file://" + URIUtil.encodePath(alias2.getPath()));
            }
        }
        catch (Exception e2) {
            LOG.warn("bad alias for {}: {}", file2, e2.toString());
            LOG.debug(e2);
            try {
                return new URI("https://eclipse.org/bad/canonical/alias");
            }
            catch (Exception ex2) {
                LOG.ignore(ex2);
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    @Override
    public Resource addPath(String path2) throws IOException {
        this.assertValidPath(path2);
        if (URIUtil.canonicalPath(path2) == null) {
            throw new MalformedURLException(path2);
        }
        if ("/".equals(path2)) {
            return this;
        }
        return new FileResource(this._file, path2);
    }

    private void assertValidPath(String path2) {
        int idx = StringUtil.indexOfControlChars(path2);
        if (idx >= 0) {
            throw new InvalidPathException(path2, "Invalid Character at index " + idx);
        }
    }

    @Override
    public URI getAlias() {
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.exists() && this._file.isDirectory() || this._uri.toASCIIString().endsWith("/");
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    @Override
    public void copyTo(File destination) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), destination);
        } else {
            if (destination.exists()) {
                throw new IllegalArgumentException(destination + " exists");
            }
            IO.copy(this.getFile(), destination);
        }
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public URL getURL() {
        try {
            return this._uri.toURL();
        }
        catch (MalformedURLException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    public String toString() {
        return this._uri.toString();
    }
}

