/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
        this._resources = new Resource[0];
    }

    public ResourceCollection(Resource ... resources) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource r : resources) {
            if (r == null) continue;
            if (r instanceof ResourceCollection) {
                Collections.addAll(list, ((ResourceCollection)r).getResources());
                continue;
            }
            list.add(r);
        }
        this._resources = list.toArray(new Resource[0]);
        for (Resource r : this._resources) {
            this.assertResourceValid(r);
        }
    }

    public ResourceCollection(String[] resources) {
        if (resources == null || resources.length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<Resource> res2 = new ArrayList<Resource>();
        try {
            for (String strResource : resources) {
                if (strResource == null || strResource.length() == 0) {
                    throw new IllegalArgumentException("empty/null resource path not supported");
                }
                Resource resource2 = Resource.newResource(strResource);
                this.assertResourceValid(resource2);
                res2.add(resource2);
            }
            if (res2.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = res2.toArray(new Resource[0]);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    public ResourceCollection(String csvResources) {
        this.setResourcesAsCSV(csvResources);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    public void setResources(Resource[] resources) {
        if (resources == null || resources.length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<Resource> res2 = new ArrayList<Resource>();
        for (Resource resource2 : resources) {
            this.assertResourceValid(resource2);
            res2.add(resource2);
        }
        if (res2.isEmpty()) {
            this._resources = null;
            return;
        }
        this._resources = res2.toArray(new Resource[0]);
    }

    public void setResourcesAsCSV(String csvResources) {
        if (csvResources == null) {
            throw new IllegalArgumentException("CSV String is null");
        }
        StringTokenizer tokenizer = new StringTokenizer(csvResources, ",;");
        int len = tokenizer.countTokens();
        if (len == 0) {
            throw new IllegalArgumentException("ResourceCollection@setResourcesAsCSV(String)  argument must be a string containing one or more comma-separated resource strings.");
        }
        ArrayList<Resource> res2 = new ArrayList<Resource>();
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() == 0) continue;
                Resource resource2 = Resource.newResource(token);
                this.assertResourceValid(resource2);
                res2.add(resource2);
            }
            if (res2.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = res2.toArray(new Resource[0]);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    public Resource addPath(String path2) throws IOException {
        int i;
        this.assertResourcesSet();
        if (path2 == null) {
            throw new MalformedURLException();
        }
        if (path2.length() == 0 || "/".equals(path2)) {
            return this;
        }
        Resource resource2 = null;
        ArrayList<Resource> resources = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource2 = this._resources[i].addPath(path2);
            if (!resource2.exists()) continue;
            if (resource2.isDirectory()) break;
            return resource2;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path2);
            if (r.exists() && r.isDirectory()) {
                if (resources == null) {
                    resources = new ArrayList<Resource>();
                }
                if (resource2 != null) {
                    resources.add(resource2);
                    resource2 = null;
                }
                resources.add(r);
            }
            ++i;
        }
        if (resource2 != null) {
            return resource2;
        }
        if (resources != null) {
            return new ResourceCollection(resources.toArray(new Resource[0]));
        }
        throw new MalformedURLException();
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public File getFile() throws IOException {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            File f = r.getFile();
            if (f == null) continue;
            return f;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            InputStream is2 = r.getInputStream();
            if (is2 == null) continue;
            return is2;
        }
        return null;
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            ReadableByteChannel channel = r.getReadableByteChannel();
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    @Override
    public String getName() {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            String name2 = r.getName();
            if (name2 == null) continue;
            return name2;
        }
        return null;
    }

    @Override
    public URL getURL() {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            URL url2 = r.getURL();
            if (url2 == null) continue;
            return url2;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public long lastModified() {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            long lm = r.lastModified();
            if (lm == -1L) continue;
            return lm;
        }
        return -1L;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String[] list() {
        this.assertResourcesSet();
        HashSet set2 = new HashSet();
        for (Resource r : this._resources) {
            String[] list = r.list();
            if (list == null) continue;
            Collections.addAll(set2, list);
        }
        Object[] result = set2.toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public void close() {
        this.assertResourcesSet();
        for (Resource r : this._resources) {
            r.close();
        }
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(File destination) throws IOException {
        this.assertResourcesSet();
        int r = this._resources.length;
        while (r-- > 0) {
            this._resources[r].copyTo(destination);
        }
    }

    public String toString() {
        if (this._resources == null || this._resources.length == 0) {
            return "[]";
        }
        return String.valueOf(Arrays.asList(this._resources));
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return false;
    }

    private void assertResourcesSet() {
        if (this._resources == null || this._resources.length == 0) {
            throw new IllegalStateException("*resources* not set.");
        }
    }

    private void assertResourceValid(Resource resource2) {
        if (resource2 == null) {
            throw new IllegalStateException("Null resource not supported");
        }
        if (!resource2.exists() || !resource2.isDirectory()) {
            throw new IllegalArgumentException(resource2 + " is not an existing directory.");
        }
    }
}

