/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.util.log.Log;

public class SerializedExecutor
implements Executor {
    private final AtomicReference<Link> _tail = new AtomicReference();

    @Override
    public void execute(Runnable task) {
        Link link2 = new Link(task);
        Link lastButOne = this._tail.getAndSet(link2);
        if (lastButOne == null) {
            this.run(link2);
        } else {
            lastButOne._next.lazySet(link2);
        }
    }

    protected void onError(Runnable task, Throwable t) {
        if (task instanceof ErrorHandlingTask) {
            ((ErrorHandlingTask)task).accept(t);
        }
        Log.getLogger(task.getClass()).warn(t);
    }

    private void run(Link link2) {
        while (link2 != null) {
            try {
                link2._task.run();
            }
            catch (Throwable t) {
                this.onError(link2._task, t);
            }
            finally {
                if (this._tail.compareAndSet(link2, null)) {
                    link2 = null;
                    continue;
                }
                Link next2 = (Link)link2._next.get();
                while (next2 == null) {
                    Thread.yield();
                    next2 = (Link)link2._next.get();
                }
                link2 = next2;
            }
        }
    }

    public static interface ErrorHandlingTask
    extends Runnable,
    Consumer<Throwable> {
    }

    private class Link {
        private final Runnable _task;
        private final AtomicReference<Link> _next = new AtomicReference();

        public Link(Runnable task) {
            this._task = task;
        }
    }
}

