/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public abstract class BaseConstructor {
    protected static final Object NOT_INSTANTIATED_OBJECT = new Object();
    protected final Map<NodeId, Construct> yamlClassConstructors = new EnumMap<NodeId, Construct>(NodeId.class);
    protected final Map<Tag, Construct> yamlConstructors = new HashMap<Tag, Construct>();
    protected final Map<String, Construct> yamlMultiConstructors = new HashMap<String, Construct>();
    protected Composer composer;
    final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Set<Node> recursiveObjects = new HashSet<Node>();
    private final ArrayList<RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>> maps2fill = new ArrayList();
    private final ArrayList<RecursiveTuple<Set<Object>, Object>> sets2fill = new ArrayList();
    protected Tag rootTag = null;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;
    private boolean allowDuplicateKeys = true;
    private boolean wrappedToRootException = false;
    private boolean enumCaseSensitive = false;
    protected final Map<Class<? extends Object>, TypeDescription> typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
    protected final Map<Tag, Class<? extends Object>> typeTags = new HashMap<Tag, Class<? extends Object>>();
    protected LoaderOptions loadingConfig;

    @Deprecated
    public BaseConstructor() {
        this(new LoaderOptions());
    }

    public BaseConstructor(LoaderOptions loadingConfig) {
        this.typeDefinitions.put(SortedMap.class, new TypeDescription(SortedMap.class, Tag.OMAP, TreeMap.class));
        this.typeDefinitions.put(SortedSet.class, new TypeDescription(SortedSet.class, Tag.SET, TreeSet.class));
        this.loadingConfig = loadingConfig;
    }

    public void setComposer(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() throws NoSuchElementException {
        if (!this.composer.checkNode()) {
            throw new NoSuchElementException("No document is available.");
        }
        Node node2 = this.composer.getNode();
        if (this.rootTag != null) {
            node2.setTag(this.rootTag);
        }
        return this.constructDocument(node2);
    }

    public Object getSingleData(Class<?> type2) {
        Node node2 = this.composer.getSingleNode();
        if (node2 != null && !Tag.NULL.equals(node2.getTag())) {
            if (Object.class != type2) {
                node2.setTag(new Tag(type2));
            } else if (this.rootTag != null) {
                node2.setTag(this.rootTag);
            }
            return this.constructDocument(node2);
        }
        Construct construct = this.yamlConstructors.get(Tag.NULL);
        return construct.construct(node2);
    }

    protected final Object constructDocument(Node node2) {
        try {
            Object data2 = this.constructObject(node2);
            this.fillRecursive();
            Object object = data2;
            return object;
        }
        catch (RuntimeException e2) {
            if (this.wrappedToRootException && !(e2 instanceof YAMLException)) {
                throw new YAMLException(e2);
            }
            throw e2;
        }
        finally {
            this.constructedObjects.clear();
            this.recursiveObjects.clear();
        }
    }

    private void fillRecursive() {
        if (!this.maps2fill.isEmpty()) {
            for (RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>> recursiveTuple : this.maps2fill) {
                RecursiveTuple<Object, Object> key_value = recursiveTuple._2();
                recursiveTuple._1().put(key_value._1(), key_value._2());
            }
            this.maps2fill.clear();
        }
        if (!this.sets2fill.isEmpty()) {
            for (RecursiveTuple<Object, Object> recursiveTuple : this.sets2fill) {
                ((Set)recursiveTuple._1()).add(recursiveTuple._2());
            }
            this.sets2fill.clear();
        }
    }

    protected Object constructObject(Node node2) {
        if (this.constructedObjects.containsKey(node2)) {
            return this.constructedObjects.get(node2);
        }
        return this.constructObjectNoCheck(node2);
    }

    protected Object constructObjectNoCheck(Node node2) {
        if (this.recursiveObjects.contains(node2)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node2.getStartMark());
        }
        this.recursiveObjects.add(node2);
        Construct constructor = this.getConstructor(node2);
        Object data2 = this.constructedObjects.containsKey(node2) ? this.constructedObjects.get(node2) : constructor.construct(node2);
        this.finalizeConstruction(node2, data2);
        this.constructedObjects.put(node2, data2);
        this.recursiveObjects.remove(node2);
        if (node2.isTwoStepsConstruction()) {
            constructor.construct2ndStep(node2, data2);
        }
        return data2;
    }

    protected Construct getConstructor(Node node2) {
        if (node2.useClassConstructor()) {
            return this.yamlClassConstructors.get((Object)node2.getNodeId());
        }
        Construct constructor = this.yamlConstructors.get(node2.getTag());
        if (constructor == null) {
            for (String prefix : this.yamlMultiConstructors.keySet()) {
                if (!node2.getTag().startsWith(prefix)) continue;
                return this.yamlMultiConstructors.get(prefix);
            }
            return this.yamlConstructors.get(null);
        }
        return constructor;
    }

    protected String constructScalar(ScalarNode node2) {
        return node2.getValue();
    }

    protected List<Object> createDefaultList(int initSize) {
        return new ArrayList<Object>(initSize);
    }

    protected Set<Object> createDefaultSet(int initSize) {
        return new LinkedHashSet<Object>(initSize);
    }

    protected Map<Object, Object> createDefaultMap(int initSize) {
        return new LinkedHashMap<Object, Object>(initSize);
    }

    protected Object createArray(Class<?> type2, int size) {
        return Array.newInstance(type2.getComponentType(), size);
    }

    protected Object finalizeConstruction(Node node2, Object data2) {
        Class<? extends Object> type2 = node2.getType();
        if (this.typeDefinitions.containsKey(type2)) {
            return this.typeDefinitions.get(type2).finalizeConstruction(data2);
        }
        return data2;
    }

    protected Object newInstance(Node node2) {
        return this.newInstance(Object.class, node2);
    }

    protected final Object newInstance(Class<?> ancestor, Node node2) {
        return this.newInstance(ancestor, node2, true);
    }

    protected Object newInstance(Class<?> ancestor, Node node2, boolean tryDefault) {
        try {
            TypeDescription td;
            Object instance;
            Class<? extends Object> type2 = node2.getType();
            if (this.typeDefinitions.containsKey(type2) && (instance = (td = this.typeDefinitions.get(type2)).newInstance(node2)) != null) {
                return instance;
            }
            if (tryDefault && ancestor.isAssignableFrom(type2) && !Modifier.isAbstract(type2.getModifiers())) {
                Constructor<? extends Object> c = type2.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
        }
        catch (Exception e2) {
            throw new YAMLException(e2);
        }
        return NOT_INSTANTIATED_OBJECT;
    }

    protected Set<Object> newSet(CollectionNode<?> node2) {
        Object instance = this.newInstance(Set.class, node2);
        if (instance != NOT_INSTANTIATED_OBJECT) {
            return (Set)instance;
        }
        return this.createDefaultSet(node2.getValue().size());
    }

    protected List<Object> newList(SequenceNode node2) {
        Object instance = this.newInstance(List.class, node2);
        if (instance != NOT_INSTANTIATED_OBJECT) {
            return (List)instance;
        }
        return this.createDefaultList(node2.getValue().size());
    }

    protected Map<Object, Object> newMap(MappingNode node2) {
        Object instance = this.newInstance(Map.class, node2);
        if (instance != NOT_INSTANTIATED_OBJECT) {
            return (Map)instance;
        }
        return this.createDefaultMap(node2.getValue().size());
    }

    protected List<? extends Object> constructSequence(SequenceNode node2) {
        List<Object> result = this.newList(node2);
        this.constructSequenceStep2(node2, result);
        return result;
    }

    protected Set<? extends Object> constructSet(SequenceNode node2) {
        Set<Object> result = this.newSet(node2);
        this.constructSequenceStep2(node2, result);
        return result;
    }

    protected Object constructArray(SequenceNode node2) {
        return this.constructArrayStep2(node2, this.createArray(node2.getType(), node2.getValue().size()));
    }

    protected void constructSequenceStep2(SequenceNode node2, Collection<Object> collection) {
        for (Node child : node2.getValue()) {
            collection.add(this.constructObject(child));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object constructArrayStep2(SequenceNode node2, Object array2) {
        Class<?> componentType = node2.getType().getComponentType();
        int index2 = 0;
        for (Node child : node2.getValue()) {
            if (child.getType() == Object.class) {
                child.setType(componentType);
            }
            Object value = this.constructObject(child);
            if (componentType.isPrimitive()) {
                if (value == null) {
                    throw new NullPointerException("Unable to construct element value for " + child);
                }
                if (Byte.TYPE.equals(componentType)) {
                    Array.setByte(array2, index2, ((Number)value).byteValue());
                } else if (Short.TYPE.equals(componentType)) {
                    Array.setShort(array2, index2, ((Number)value).shortValue());
                } else if (Integer.TYPE.equals(componentType)) {
                    Array.setInt(array2, index2, ((Number)value).intValue());
                } else if (Long.TYPE.equals(componentType)) {
                    Array.setLong(array2, index2, ((Number)value).longValue());
                } else if (Float.TYPE.equals(componentType)) {
                    Array.setFloat(array2, index2, ((Number)value).floatValue());
                } else if (Double.TYPE.equals(componentType)) {
                    Array.setDouble(array2, index2, ((Number)value).doubleValue());
                } else if (Character.TYPE.equals(componentType)) {
                    Array.setChar(array2, index2, ((Character)value).charValue());
                } else {
                    if (!Boolean.TYPE.equals(componentType)) throw new YAMLException("unexpected primitive type");
                    Array.setBoolean(array2, index2, (Boolean)value);
                }
            } else {
                Array.set(array2, index2, value);
            }
            ++index2;
        }
        return array2;
    }

    protected Set<Object> constructSet(MappingNode node2) {
        Set<Object> set2 = this.newSet(node2);
        this.constructSet2ndStep(node2, set2);
        return set2;
    }

    protected Map<Object, Object> constructMapping(MappingNode node2) {
        Map<Object, Object> mapping = this.newMap(node2);
        this.constructMapping2ndStep(node2, mapping);
        return mapping;
    }

    protected void constructMapping2ndStep(MappingNode node2, Map<Object, Object> mapping) {
        List<NodeTuple> nodeValue = node2.getValue();
        for (NodeTuple tuple2 : nodeValue) {
            Node keyNode = tuple2.getKeyNode();
            Node valueNode = tuple2.getValueNode();
            Object key2 = this.constructObject(keyNode);
            if (key2 != null) {
                try {
                    key2.hashCode();
                }
                catch (Exception e2) {
                    throw new ConstructorException("while constructing a mapping", node2.getStartMark(), "found unacceptable key " + key2, tuple2.getKeyNode().getStartMark(), e2);
                }
            }
            Object value = this.constructObject(valueNode);
            if (keyNode.isTwoStepsConstruction()) {
                if (this.loadingConfig.getAllowRecursiveKeys()) {
                    this.postponeMapFilling(mapping, key2, value);
                    continue;
                }
                throw new YAMLException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            mapping.put(key2, value);
        }
    }

    protected void postponeMapFilling(Map<Object, Object> mapping, Object key2, Object value) {
        this.maps2fill.add(0, new RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>(mapping, new RecursiveTuple<Object, Object>(key2, value)));
    }

    protected void constructSet2ndStep(MappingNode node2, Set<Object> set2) {
        List<NodeTuple> nodeValue = node2.getValue();
        for (NodeTuple tuple2 : nodeValue) {
            Node keyNode = tuple2.getKeyNode();
            Object key2 = this.constructObject(keyNode);
            if (key2 != null) {
                try {
                    key2.hashCode();
                }
                catch (Exception e2) {
                    throw new ConstructorException("while constructing a Set", node2.getStartMark(), "found unacceptable key " + key2, tuple2.getKeyNode().getStartMark(), e2);
                }
            }
            if (keyNode.isTwoStepsConstruction()) {
                this.postponeSetFilling(set2, key2);
                continue;
            }
            set2.add(key2);
        }
    }

    protected void postponeSetFilling(Set<Object> set2, Object key2) {
        this.sets2fill.add(0, new RecursiveTuple<Set<Object>, Object>(set2, key2));
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        this.explicitPropertyUtils = true;
        Collection<TypeDescription> tds = this.typeDefinitions.values();
        for (TypeDescription typeDescription : tds) {
            typeDescription.setPropertyUtils(propertyUtils);
        }
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        Tag tag = definition.getTag();
        this.typeTags.put(tag, definition.getType());
        definition.setPropertyUtils(this.getPropertyUtils());
        return this.typeDefinitions.put(definition.getType(), definition);
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }

    public boolean isAllowDuplicateKeys() {
        return this.allowDuplicateKeys;
    }

    public void setAllowDuplicateKeys(boolean allowDuplicateKeys) {
        this.allowDuplicateKeys = allowDuplicateKeys;
    }

    public boolean isWrappedToRootException() {
        return this.wrappedToRootException;
    }

    public void setWrappedToRootException(boolean wrappedToRootException) {
        this.wrappedToRootException = wrappedToRootException;
    }

    public boolean isEnumCaseSensitive() {
        return this.enumCaseSensitive;
    }

    public void setEnumCaseSensitive(boolean enumCaseSensitive) {
        this.enumCaseSensitive = enumCaseSensitive;
    }

    private static class RecursiveTuple<T, K> {
        private final T _1;
        private final K _2;

        public RecursiveTuple(T _1, K _2) {
            this._1 = _1;
            this._2 = _2;
        }

        public K _2() {
            return this._2;
        }

        public T _1() {
            return this._1;
        }
    }
}

