/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.DuplicateKeyException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.util.EnumUtils;

public class Constructor
extends SafeConstructor {
    @Deprecated
    public Constructor() {
        this(Object.class);
    }

    public Constructor(LoaderOptions loadingConfig) {
        this(Object.class, loadingConfig);
    }

    public Constructor(Class<? extends Object> theRoot) {
        this(new TypeDescription(Constructor.checkRoot(theRoot)));
    }

    public Constructor(Class<? extends Object> theRoot, LoaderOptions loadingConfig) {
        this(new TypeDescription(Constructor.checkRoot(theRoot)), null, loadingConfig);
    }

    private static Class<? extends Object> checkRoot(Class<? extends Object> theRoot) {
        if (theRoot == null) {
            throw new NullPointerException("Root class must be provided.");
        }
        return theRoot;
    }

    @Deprecated
    public Constructor(TypeDescription theRoot) {
        this(theRoot, null, new LoaderOptions());
    }

    public Constructor(TypeDescription theRoot, LoaderOptions loadingConfig) {
        this(theRoot, null, loadingConfig);
    }

    public Constructor(TypeDescription theRoot, Collection<TypeDescription> moreTDs, LoaderOptions loadingConfig) {
        super(loadingConfig);
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject());
        if (!Object.class.equals(theRoot.getType())) {
            this.rootTag = new Tag(theRoot.getType());
        }
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructScalar());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping());
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequence());
        this.addTypeDescription(theRoot);
        if (moreTDs != null) {
            for (TypeDescription td : moreTDs) {
                this.addTypeDescription(td);
            }
        }
    }

    public Constructor(String theRoot) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)));
    }

    public Constructor(String theRoot, LoaderOptions loadingConfig) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)), loadingConfig);
    }

    private static final String check(String s) {
        if (s == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (s.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return s;
    }

    protected Class<?> getClassForNode(Node node2) {
        Class classForTag = (Class)this.typeTags.get(node2.getTag());
        if (classForTag == null) {
            Class<?> cl;
            String name2 = node2.getTag().getClassName();
            try {
                cl = this.getClassForName(name2);
            }
            catch (ClassNotFoundException e2) {
                throw new YAMLException("Class not found: " + name2);
            }
            this.typeTags.put(node2.getTag(), cl);
            return cl;
        }
        return classForTag;
    }

    protected Class<?> getClassForName(String name2) throws ClassNotFoundException {
        try {
            return Class.forName(name2, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e2) {
            return Class.forName(name2);
        }
    }

    protected class ConstructSequence
    implements Construct {
        protected ConstructSequence() {
        }

        @Override
        public Object construct(Node node2) {
            SequenceNode snode = (SequenceNode)node2;
            if (Set.class.isAssignableFrom(node2.getType())) {
                if (node2.isTwoStepsConstruction()) {
                    throw new YAMLException("Set cannot be recursive.");
                }
                return Constructor.this.constructSet(snode);
            }
            if (Collection.class.isAssignableFrom(node2.getType())) {
                if (node2.isTwoStepsConstruction()) {
                    return Constructor.this.newList(snode);
                }
                return Constructor.this.constructSequence(snode);
            }
            if (node2.getType().isArray()) {
                if (node2.isTwoStepsConstruction()) {
                    return Constructor.this.createArray(node2.getType(), snode.getValue().size());
                }
                return Constructor.this.constructArray(snode);
            }
            ArrayList possibleConstructors = new ArrayList(snode.getValue().size());
            for (java.lang.reflect.Constructor<?> constructor : node2.getType().getDeclaredConstructors()) {
                if (snode.getValue().size() != constructor.getParameterTypes().length) continue;
                possibleConstructors.add(constructor);
            }
            if (!possibleConstructors.isEmpty()) {
                Object argumentList;
                if (possibleConstructors.size() == 1) {
                    argumentList = new Object[snode.getValue().size()];
                    java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)possibleConstructors.get(0);
                    int index2 = 0;
                    for (Node node3 : snode.getValue()) {
                        Class<?> type2 = c.getParameterTypes()[index2];
                        node3.setType(type2);
                        argumentList[index2++] = Constructor.this.constructObject(node3);
                    }
                    try {
                        c.setAccessible(true);
                        return c.newInstance((Object[])argumentList);
                    }
                    catch (Exception e2) {
                        throw new YAMLException(e2);
                    }
                }
                argumentList = Constructor.this.constructSequence(snode);
                Class[] parameterTypes = new Class[argumentList.size()];
                int index2 = 0;
                Iterator iterator = argumentList.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    parameterTypes[index2] = e2.getClass();
                    ++index2;
                }
                for (java.lang.reflect.Constructor constructor : possibleConstructors) {
                    Class<?>[] argTypes = constructor.getParameterTypes();
                    boolean foundConstructor = true;
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (this.wrapIfPrimitive(argTypes[i]).isAssignableFrom(parameterTypes[i])) continue;
                        foundConstructor = false;
                        break;
                    }
                    if (!foundConstructor) continue;
                    try {
                        constructor.setAccessible(true);
                        return constructor.newInstance(argumentList.toArray());
                    }
                    catch (Exception e3) {
                        throw new YAMLException(e3);
                    }
                }
            }
            throw new YAMLException("No suitable constructor with " + snode.getValue().size() + " arguments found for " + node2.getType());
        }

        private final Class<? extends Object> wrapIfPrimitive(Class<?> clazz) {
            if (!clazz.isPrimitive()) {
                return clazz;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            throw new YAMLException("Unexpected primitive " + clazz);
        }

        @Override
        public void construct2ndStep(Node node2, Object object) {
            SequenceNode snode = (SequenceNode)node2;
            if (List.class.isAssignableFrom(node2.getType())) {
                List list = (List)object;
                Constructor.this.constructSequenceStep2(snode, list);
            } else if (node2.getType().isArray()) {
                Constructor.this.constructArrayStep2(snode, object);
            } else {
                throw new YAMLException("Immutable objects cannot be recursive.");
            }
        }
    }

    protected class ConstructScalar
    extends AbstractConstruct {
        protected ConstructScalar() {
        }

        @Override
        public Object construct(Node nnode) {
            Object result;
            ScalarNode node2 = (ScalarNode)nnode;
            Class<? extends Object> type2 = node2.getType();
            Object instance = Constructor.this.newInstance(type2, node2, false);
            if (instance != BaseConstructor.NOT_INSTANTIATED_OBJECT) {
                return instance;
            }
            if (type2.isPrimitive() || type2 == String.class || Number.class.isAssignableFrom(type2) || type2 == Boolean.class || Date.class.isAssignableFrom(type2) || type2 == Character.class || type2 == BigInteger.class || type2 == BigDecimal.class || Enum.class.isAssignableFrom(type2) || Tag.BINARY.equals(node2.getTag()) || Calendar.class.isAssignableFrom(type2) || type2 == UUID.class) {
                result = this.constructStandardJavaInstance(type2, node2);
            } else {
                Object argument;
                java.lang.reflect.Constructor<?>[] javaConstructors = type2.getDeclaredConstructors();
                int oneArgCount = 0;
                java.lang.reflect.Constructor<Object> javaConstructor = null;
                for (java.lang.reflect.Constructor<?> c : javaConstructors) {
                    if (c.getParameterTypes().length != 1) continue;
                    ++oneArgCount;
                    javaConstructor = c;
                }
                if (javaConstructor == null) {
                    throw new YAMLException("No single argument constructor found for " + type2);
                }
                if (oneArgCount == 1) {
                    argument = this.constructStandardJavaInstance(javaConstructor.getParameterTypes()[0], node2);
                } else {
                    argument = Constructor.this.constructScalar(node2);
                    try {
                        javaConstructor = type2.getDeclaredConstructor(String.class);
                    }
                    catch (Exception e2) {
                        throw new YAMLException("Can't construct a java object for scalar " + node2.getTag() + "; No String constructor found. Exception=" + e2.getMessage(), e2);
                    }
                }
                try {
                    javaConstructor.setAccessible(true);
                    result = javaConstructor.newInstance(argument);
                }
                catch (Exception e3) {
                    throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node2.getTag() + "; exception=" + e3.getMessage(), node2.getStartMark(), e3);
                }
            }
            return result;
        }

        private Object constructStandardJavaInstance(Class type2, ScalarNode node2) {
            Object result;
            if (type2 == String.class) {
                Construct stringConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.STR);
                result = stringConstructor.construct(node2);
            } else if (type2 == Boolean.class || type2 == Boolean.TYPE) {
                Construct boolConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.BOOL);
                result = boolConstructor.construct(node2);
            } else if (type2 == Character.class || type2 == Character.TYPE) {
                Construct charConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.STR);
                String ch = (String)charConstructor.construct(node2);
                if (ch.length() == 0) {
                    result = null;
                } else {
                    if (ch.length() != 1) {
                        throw new YAMLException("Invalid node Character: '" + ch + "'; length: " + ch.length());
                    }
                    result = Character.valueOf(ch.charAt(0));
                }
            } else if (Date.class.isAssignableFrom(type2)) {
                Construct dateConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.TIMESTAMP);
                Date date = (Date)dateConstructor.construct(node2);
                if (type2 == Date.class) {
                    result = date;
                } else {
                    try {
                        java.lang.reflect.Constructor constr = type2.getConstructor(Long.TYPE);
                        result = constr.newInstance(date.getTime());
                    }
                    catch (RuntimeException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        throw new YAMLException("Cannot construct: '" + type2 + "'");
                    }
                }
            } else if (type2 == Float.class || type2 == Double.class || type2 == Float.TYPE || type2 == Double.TYPE || type2 == BigDecimal.class) {
                if (type2 == BigDecimal.class) {
                    result = new BigDecimal(node2.getValue());
                } else {
                    Construct doubleConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.FLOAT);
                    result = doubleConstructor.construct(node2);
                    if (type2 == Float.class || type2 == Float.TYPE) {
                        result = Float.valueOf(((Double)result).floatValue());
                    }
                }
            } else if (type2 == Byte.class || type2 == Short.class || type2 == Integer.class || type2 == Long.class || type2 == BigInteger.class || type2 == Byte.TYPE || type2 == Short.TYPE || type2 == Integer.TYPE || type2 == Long.TYPE) {
                Construct intConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.INT);
                result = intConstructor.construct(node2);
                result = type2 == Byte.class || type2 == Byte.TYPE ? (Number)Integer.valueOf(result.toString()).byteValue() : (Number)(type2 == Short.class || type2 == Short.TYPE ? (Number)Integer.valueOf(result.toString()).shortValue() : (Number)(type2 == Integer.class || type2 == Integer.TYPE ? (Number)Integer.parseInt(result.toString()) : (Number)(type2 == Long.class || type2 == Long.TYPE ? Long.valueOf(result.toString()) : new BigInteger(result.toString()))));
            } else if (Enum.class.isAssignableFrom(type2)) {
                String enumValueName = node2.getValue();
                try {
                    if (Constructor.this.loadingConfig.isEnumCaseSensitive()) {
                        result = Enum.valueOf(type2, enumValueName);
                    }
                    result = EnumUtils.findEnumInsensitiveCase(type2, enumValueName);
                }
                catch (Exception ex) {
                    throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + type2.getName());
                }
            } else if (Calendar.class.isAssignableFrom(type2)) {
                SafeConstructor.ConstructYamlTimestamp contr = new SafeConstructor.ConstructYamlTimestamp();
                contr.construct(node2);
                result = contr.getCalendar();
            } else if (Number.class.isAssignableFrom(type2)) {
                SafeConstructor.ConstructYamlFloat contr = new SafeConstructor.ConstructYamlFloat();
                result = contr.construct(node2);
            } else if (UUID.class == type2) {
                result = UUID.fromString(node2.getValue());
            } else if (Constructor.this.yamlConstructors.containsKey(node2.getTag())) {
                result = ((Construct)Constructor.this.yamlConstructors.get(node2.getTag())).construct(node2);
            } else {
                throw new YAMLException("Unsupported class: " + type2);
            }
            return result;
        }
    }

    protected class ConstructYamlObject
    implements Construct {
        protected ConstructYamlObject() {
        }

        private Construct getConstructor(Node node2) {
            Class<?> cl = Constructor.this.getClassForNode(node2);
            node2.setType(cl);
            Construct constructor = (Construct)Constructor.this.yamlClassConstructors.get((Object)node2.getNodeId());
            return constructor;
        }

        @Override
        public Object construct(Node node2) {
            try {
                return this.getConstructor(node2).construct(node2);
            }
            catch (ConstructorException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node2.getTag() + "; exception=" + e3.getMessage(), node2.getStartMark(), e3);
            }
        }

        @Override
        public void construct2ndStep(Node node2, Object object) {
            try {
                this.getConstructor(node2).construct2ndStep(node2, object);
            }
            catch (Exception e2) {
                throw new ConstructorException(null, null, "Can't construct a second step for a java object for " + node2.getTag() + "; exception=" + e2.getMessage(), node2.getStartMark(), e2);
            }
        }
    }

    protected class ConstructMapping
    implements Construct {
        protected ConstructMapping() {
        }

        @Override
        public Object construct(Node node2) {
            MappingNode mnode = (MappingNode)node2;
            if (Map.class.isAssignableFrom(node2.getType())) {
                if (node2.isTwoStepsConstruction()) {
                    return Constructor.this.newMap(mnode);
                }
                return Constructor.this.constructMapping(mnode);
            }
            if (Collection.class.isAssignableFrom(node2.getType())) {
                if (node2.isTwoStepsConstruction()) {
                    return Constructor.this.newSet(mnode);
                }
                return Constructor.this.constructSet(mnode);
            }
            Object obj = Constructor.this.newInstance(mnode);
            if (obj != BaseConstructor.NOT_INSTANTIATED_OBJECT) {
                if (node2.isTwoStepsConstruction()) {
                    return obj;
                }
                return this.constructJavaBean2ndStep(mnode, obj);
            }
            throw new ConstructorException(null, null, "Can't create an instance for " + mnode.getTag(), node2.getStartMark());
        }

        @Override
        public void construct2ndStep(Node node2, Object object) {
            if (Map.class.isAssignableFrom(node2.getType())) {
                Constructor.this.constructMapping2ndStep((MappingNode)node2, (Map)object);
            } else if (Set.class.isAssignableFrom(node2.getType())) {
                Constructor.this.constructSet2ndStep((MappingNode)node2, (Set)object);
            } else {
                this.constructJavaBean2ndStep((MappingNode)node2, object);
            }
        }

        protected Object constructJavaBean2ndStep(MappingNode node2, Object object) {
            Constructor.this.flattenMapping(node2, true);
            Class<? extends Object> beanType = node2.getType();
            List<NodeTuple> nodeValue = node2.getValue();
            for (NodeTuple tuple2 : nodeValue) {
                Node valueNode = tuple2.getValueNode();
                String key2 = (String)Constructor.this.constructObject(tuple2.getKeyNode());
                try {
                    Object value;
                    Class<?>[] arguments;
                    boolean typeDetected;
                    Property property;
                    TypeDescription memberDescription = (TypeDescription)Constructor.this.typeDefinitions.get(beanType);
                    Property property2 = property = memberDescription == null ? this.getProperty(beanType, key2) : memberDescription.getProperty(key2);
                    if (!property.isWritable()) {
                        throw new YAMLException("No writable property '" + key2 + "' on class: " + beanType.getName());
                    }
                    valueNode.setType(property.getType());
                    boolean bl = typeDetected = memberDescription != null && memberDescription.setupPropertyType(key2, valueNode);
                    if (!typeDetected && valueNode.getNodeId() != NodeId.scalar && (arguments = property.getActualTypeArguments()) != null && arguments.length > 0) {
                        Class<?> t;
                        if (valueNode.getNodeId() == NodeId.sequence) {
                            t = arguments[0];
                            SequenceNode snode = (SequenceNode)valueNode;
                            snode.setListType(t);
                        } else if (Map.class.isAssignableFrom(valueNode.getType())) {
                            Class<?> keyType = arguments[0];
                            Class<?> valueType = arguments[1];
                            MappingNode mnode = (MappingNode)valueNode;
                            mnode.setTypes(keyType, valueType);
                            mnode.setUseClassConstructor(true);
                        } else if (Collection.class.isAssignableFrom(valueNode.getType())) {
                            t = arguments[0];
                            MappingNode mnode = (MappingNode)valueNode;
                            mnode.setOnlyKeyType(t);
                            mnode.setUseClassConstructor(true);
                        }
                    }
                    Object object2 = value = memberDescription != null ? this.newInstance(memberDescription, key2, valueNode) : Constructor.this.constructObject(valueNode);
                    if ((property.getType() == Float.TYPE || property.getType() == Float.class) && value instanceof Double) {
                        value = Float.valueOf(((Double)value).floatValue());
                    }
                    if (property.getType() == String.class && Tag.BINARY.equals(valueNode.getTag()) && value instanceof byte[]) {
                        value = new String((byte[])value);
                    }
                    if (memberDescription != null && memberDescription.setProperty(object, key2, value)) continue;
                    property.set(object, value);
                }
                catch (DuplicateKeyException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new ConstructorException("Cannot create property=" + key2 + " for JavaBean=" + object, node2.getStartMark(), e3.getMessage(), valueNode.getStartMark(), e3);
                }
            }
            return object;
        }

        private Object newInstance(TypeDescription memberDescription, String propertyName, Node node2) {
            Object newInstance = memberDescription.newInstance(propertyName, node2);
            if (newInstance != null) {
                Constructor.this.constructedObjects.put(node2, newInstance);
                return Constructor.this.constructObjectNoCheck(node2);
            }
            return Constructor.this.constructObject(node2);
        }

        protected Property getProperty(Class<? extends Object> type2, String name2) {
            return Constructor.this.getPropertyUtils().getProperty(type2, name2);
        }
    }
}

