/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.env;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MissingEnvironmentVariableException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class EnvScalarConstructor
extends Constructor {
    public static final Tag ENV_TAG = new Tag("!ENV");
    public static final Pattern ENV_FORMAT = Pattern.compile("^\\$\\{\\s*((?<name>\\w+)((?<separator>:?(-|\\?))(?<value>\\S+)?)?)\\s*\\}$");

    public EnvScalarConstructor() {
        super(new LoaderOptions());
        this.yamlConstructors.put(ENV_TAG, new ConstructEnv());
    }

    public EnvScalarConstructor(TypeDescription theRoot, Collection<TypeDescription> moreTDs, LoaderOptions loadingConfig) {
        super(theRoot, moreTDs, loadingConfig);
        this.yamlConstructors.put(ENV_TAG, new ConstructEnv());
    }

    public String apply(String name2, String separator2, String value, String environment) {
        if (environment != null && !environment.isEmpty()) {
            return environment;
        }
        if (separator2 != null) {
            if (separator2.equals("?") && environment == null) {
                throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value);
            }
            if (separator2.equals(":?")) {
                if (environment == null) {
                    throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value);
                }
                if (environment.isEmpty()) {
                    throw new MissingEnvironmentVariableException("Empty mandatory variable " + name2 + ": " + value);
                }
            }
            if (separator2.startsWith(":") ? environment == null || environment.isEmpty() : environment == null) {
                return value;
            }
        }
        return "";
    }

    public String getEnv(String key2) {
        return System.getenv(key2);
    }

    private class ConstructEnv
    extends AbstractConstruct {
        private ConstructEnv() {
        }

        @Override
        public Object construct(Node node2) {
            String val2 = EnvScalarConstructor.this.constructScalar((ScalarNode)node2);
            Matcher matcher = ENV_FORMAT.matcher(val2);
            matcher.matches();
            String name2 = matcher.group("name");
            String value = matcher.group("value");
            String separator2 = matcher.group("separator");
            return EnvScalarConstructor.this.apply(name2, separator2, value != null ? value : "", EnvScalarConstructor.this.getEnv(name2));
        }
    }
}

