/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.extensions.compactnotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.extensions.compactnotation.CompactData;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class CompactConstructor
extends Constructor {
    private static final Pattern GUESS_COMPACT = Pattern.compile("\\p{Alpha}.*\\s*\\((?:,?\\s*(?:(?:\\w*)|(?:\\p{Alpha}\\w*\\s*=.+))\\s*)+\\)");
    private static final Pattern FIRST_PATTERN = Pattern.compile("(\\p{Alpha}.*)(\\s*)\\((.*?)\\)");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\s*(\\p{Alpha}\\w*)\\s*=(.+)");
    private Construct compactConstruct;

    public CompactConstructor(LoaderOptions loadingConfig) {
        super(loadingConfig);
    }

    public CompactConstructor() {
        super(new LoaderOptions());
    }

    protected Object constructCompactFormat(ScalarNode node2, CompactData data2) {
        try {
            Object obj = this.createInstance(node2, data2);
            HashMap<String, Object> properties = new HashMap<String, Object>(data2.getProperties());
            this.setProperties(obj, properties);
            return obj;
        }
        catch (Exception e2) {
            throw new YAMLException(e2);
        }
    }

    protected Object createInstance(ScalarNode node2, CompactData data2) throws Exception {
        Class<?> clazz = this.getClassForName(data2.getPrefix());
        Class[] args = new Class[data2.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = String.class;
        }
        java.lang.reflect.Constructor<?> c = clazz.getDeclaredConstructor(args);
        c.setAccessible(true);
        return c.newInstance(data2.getArguments().toArray());
    }

    protected void setProperties(Object bean2, Map<String, Object> data2) throws Exception {
        if (data2 == null) {
            throw new NullPointerException("Data for Compact Object Notation cannot be null.");
        }
        for (Map.Entry<String, Object> entry2 : data2.entrySet()) {
            String key2 = entry2.getKey();
            Property property = this.getPropertyUtils().getProperty(bean2.getClass(), key2);
            try {
                property.set(bean2, entry2.getValue());
            }
            catch (IllegalArgumentException e2) {
                throw new YAMLException("Cannot set property='" + key2 + "' with value='" + data2.get(key2) + "' (" + data2.get(key2).getClass() + ") in " + bean2);
            }
        }
    }

    public CompactData getCompactData(String scalar) {
        if (!scalar.endsWith(")")) {
            return null;
        }
        if (scalar.indexOf(40) < 0) {
            return null;
        }
        Matcher m = FIRST_PATTERN.matcher(scalar);
        if (m.matches()) {
            String tag = m.group(1).trim();
            String content = m.group(3);
            CompactData data2 = new CompactData(tag);
            if (content.length() == 0) {
                return data2;
            }
            String[] names = content.split("\\s*,\\s*");
            for (int i = 0; i < names.length; ++i) {
                String section = names[i];
                if (section.indexOf(61) < 0) {
                    data2.getArguments().add(section);
                    continue;
                }
                Matcher sm = PROPERTY_NAME_PATTERN.matcher(section);
                if (sm.matches()) {
                    String name2 = sm.group(1);
                    String value = sm.group(2).trim();
                    data2.getProperties().put(name2, value);
                    continue;
                }
                return null;
            }
            return data2;
        }
        return null;
    }

    private Construct getCompactConstruct() {
        if (this.compactConstruct == null) {
            this.compactConstruct = this.createCompactConstruct();
        }
        return this.compactConstruct;
    }

    protected Construct createCompactConstruct() {
        return new ConstructCompactObject();
    }

    @Override
    protected Construct getConstructor(Node node2) {
        ScalarNode scalar;
        ScalarNode scalar2;
        NodeTuple tuple2;
        Node key2;
        MappingNode mnode;
        List<NodeTuple> list;
        if (node2 instanceof MappingNode ? (list = (mnode = (MappingNode)node2).getValue()).size() == 1 && (key2 = (tuple2 = list.get(0)).getKeyNode()) instanceof ScalarNode && GUESS_COMPACT.matcher((scalar2 = (ScalarNode)key2).getValue()).matches() : node2 instanceof ScalarNode && GUESS_COMPACT.matcher((scalar = (ScalarNode)node2).getValue()).matches()) {
            return this.getCompactConstruct();
        }
        return super.getConstructor(node2);
    }

    protected void applySequence(Object bean2, List<?> value) {
        try {
            Property property = this.getPropertyUtils().getProperty(bean2.getClass(), this.getSequencePropertyName(bean2.getClass()));
            property.set(bean2, value);
        }
        catch (Exception e2) {
            throw new YAMLException(e2);
        }
    }

    protected String getSequencePropertyName(Class<?> bean2) {
        Set<Property> properties = this.getPropertyUtils().getProperties(bean2);
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (List.class.isAssignableFrom(property.getType())) continue;
            iterator.remove();
        }
        if (properties.size() == 0) {
            throw new YAMLException("No list property found in " + bean2);
        }
        if (properties.size() > 1) {
            throw new YAMLException("Many list properties found in " + bean2 + "; Please override getSequencePropertyName() to specify which property to use.");
        }
        return properties.iterator().next().getName();
    }

    public class ConstructCompactObject
    extends Constructor.ConstructMapping {
        @Override
        public void construct2ndStep(Node node2, Object object) {
            MappingNode mnode = (MappingNode)node2;
            NodeTuple nodeTuple = mnode.getValue().iterator().next();
            Node valueNode = nodeTuple.getValueNode();
            if (valueNode instanceof MappingNode) {
                valueNode.setType(object.getClass());
                this.constructJavaBean2ndStep((MappingNode)valueNode, object);
            } else {
                CompactConstructor.this.applySequence(object, CompactConstructor.this.constructSequence((SequenceNode)valueNode));
            }
        }

        @Override
        public Object construct(Node node2) {
            ScalarNode tmpNode;
            if (node2 instanceof MappingNode) {
                MappingNode mnode = (MappingNode)node2;
                NodeTuple nodeTuple = mnode.getValue().iterator().next();
                node2.setTwoStepsConstruction(true);
                tmpNode = (ScalarNode)nodeTuple.getKeyNode();
            } else {
                tmpNode = (ScalarNode)node2;
            }
            CompactData data2 = CompactConstructor.this.getCompactData(tmpNode.getValue());
            if (data2 == null) {
                return CompactConstructor.this.constructScalar(tmpNode);
            }
            return CompactConstructor.this.constructCompactFormat(tmpNode, data2);
        }
    }
}

