---
title: Creating This Blog
---

## Creating This Blog

It probably hasn't escaped your notice that this is a less than gorgeous site.  That's actually partially deliberate, but mostly a side effect of the technology I'm using.  Since this is intended to be an exercise in selfhosting and digital control, my primary requirement was a stack I could have full knowledge of, so I can hack together modifications.  The other reason is that I'm just not a frontend guy by any stretch of the imagination.  If I have to think about the actual HTML more than once at setup, something has gone wrong.  After looking over my options, I at first thought I was going to have to go with something like Jekyll but I wound up reading [this guy](http://wstyler.ucsd.edu/posts/pandoc_website.html) and became a convert.  This website is held together with prayer, bash, pandoc, and worst of all docker, but it's mine.

### The Hardware

Static websites like this one are incredibly resource cheap.  Unless a client is requesting a file, the server is just quietly awaiting an HTTP connection.  For many people, even the free tier on something like Google Cloud or a cheap droplet on Digital Ocean is more than enough, at least unless you completely blow up in popularity.  However, it is equally true that most people have a device at home that can run a webserver quite well.  An older laptop is likely able to cope, but I happened to have a server sitting downstairs in my basement, so this website lives there.

When setting up a computer for home server use, I have to recommend putting your favorite flavor of Linux on it.  That's probably just bias talking, since I'm honestly too dumb to do anything on a platform I'm not used to, but it really is trivial to do something hacky like this with Linux.  In terms of what distro, I'm going to go against the norm and say whatever distro you are personally more comfortable with.  I made the mistake of putting CentOS on my home server, and I intend to slap Arch on there as soon as possible.  That's not to say that CentOS is in any way a bad distro, I've been really impressed with its reliability and setup.  I just don't know what I'm doing! My career isn't going to be in this area, and frankly all the additional stability of a real professional distro like CentOS or Ubuntu Server is wasted on someone like me, who has 7 services of which 6 are containerized anyway.

Speaking of containerization, that's how I'm actually serving the website.  Most of my selfhosted services are just docker containers I ripped straight off of dockerhub because its not a real production system and I'm lazy, so one more hurts no one.  I didn't want something especially heavy since I'm just serving a static site, so I use the lovely and lightweight [halverneus/static-file-server](https://hub.docker.com/r/halverneus/static-file-server/).I am well aware that I probably shouldn't be using someone else's image for this, but I was also too lazy to write my own.  Sometime soon I hope to put together an even smaller fileserver that only does exactly what I need it to do.  For now its nice just to have a simple container to stand up when I need to that takes almost no resources at all, especially since I can just hook it into Traefik, which I use for the rest of my services as well.

### The Content

As I alluded to before, this website is written in markdown and turned into HTML by [pandoc](https://pandoc.org/), an incredibly useful tool for converting between document types written in Haskel.  This is a super easy process, although figuring out the exact syntax of the command definitely took some work.  On my Github profile I will soon have a repo featuring my script for your personal perusal, but the centerpiece is this command here:

```
pandoc -s -o "$filePath".html -B formatting/header.html \
--template=custom.html5 "$filePath".md
```

It's kind of a lot, but it's pretty simple underneath.  This command takes $filePath.md, prepends a header written in HTML (That's the consistent stuff at the top of each page), and spits the whole thing out into $filePath.html.  The CSS is applied to the header, and carries over for the entire document.

Speaking of CSS, that pseudolanguage is way easier than I thought it would be.  With some fairly intuitive structuring and some trial and error, it's easy to put something together that isn't a complete abomination.  The color pallet needs a little work but all things considered it's pretty well built.  Feel free to steal the stylesheet [here](/stylesheet.css).

The magic comes from a bash script that I wrote to handle the annoying task of actually publishing these pages.  It does the work of finding .md files, generating the header, generating the final page, and moving the whole tree over to my server for the file server to find.  Actually, because I wrote the script to just copy the entire directory, if you turn your browser to your choice of webpages and tack on a .md rather than an .html you can see the original markdown.

The most interesting thing about the whole setup is the minor change I made to the header command to make a different epithet to appear on each page.  All it does is scan through the markdown, find a placeholder line, replace it with a randomly chosen line from a list, and proceed as normal.  From there the rest is trivial.
