---
title: Installing Arch
---

## Installing Arch: A Not Guide

Yes, yes, I use arch.  BTW.  Whatever.  I'm not a system administrator,
or a programmer, and I can't fix a system if I didn't have a pretty
significant hand in deciding how it's set up.  Ubuntu was great, and I
can tell that CentOS is a damn good distro for someone who knows what
they're doing, but I don't have the mental capacity to remember my exam
until the day I have to take it, let alone how someone else set up my
OS.  So I use Arch.

Whatever they might tell you, installing Arch isn't actually hard once
you get your head around a few little details.  If you just follow the
manual step by step, you can get yourself a pretty decent system set up
in no time, though with a few hiccups.  The trouble, I find, comes when
you have more specific needs.  There are blog posts and guides, but if
you have more than one additional requirement it's hard to find what
you're looking for.  In the end, however, once you know all the moving
parts it's incredibly easy to set up your system exactly how you want
to.  I'll go over my needs and setup, then what I learned from
installing.  I won't go into a step by step install guide, although I
hope that you won't have need of it.  Just following steps blindly
is how you wind up like I did before I read the docs and learned;
confused and worried.

### My Setup

Going into my arch install, I had three specific requirements that I was
a little worried about.  Each had guides alone, but I could find very
little that dealt with all of them at once.

- BTRFS is my filesystem of choice, with snapshots coming in handy all
  the time.  The problem is that most of the time you see BTRFS
  installed on root in a way that makes it hard to roll back changes,
  and I was confused as to how I should set up my subvolumes.
- Full disk encryption with LUKS is handy to have on a laptop, just in
  case BCPD catches on to my meth cooking operation.  I also wanted
  encrypted swap for hibernation, which is a little harder to find
  guides for.
- Dual booting with Windows isn't especially hard, but again, there
  aren't any guides for combining with my other requirements

I spent far too long scratching my head over these issues, but
eventually I worked it out.  It wasn't hard at all once I worked out
what the moving parts where, and now I'm confident that I could set up
my computer from scratch again.  Hopefully you will be too.

### BTRFS

A warning before we start: If you actually know anything about BTRFS
administration, please don't read this section.  It will only bring you
pain.  That out of the way, lets dive into my understanding of BTRFS.

BTRFS is a copy-on-write filesystem, which has lots of useful features
and consists mostly of things I don't understand.  For casual use, the
cool features of BTRFS are snapshots and subvolumes:

- Snapshots: A snapshot is just that, a frozen instance of your entire
  filesystem with all its files.  A snapshot only stores the changes
  from some known state, meaning they are extremely lightweight.  If you
  take a snapshot, then make some changes, you can revert to exactly how
  things were at the snapshot.
- Subvolumes: A subvolume is like a little mini filesystem.  I mostly
  use them to break up snapshots, since a snapshot does not extend to
  subvolumes within the subvolume being snapshotted.

I was confused primarily because I didn't quite understand what
subvolumes were.  I still don't but I at least know how they behave.
A subvolume acts for all intents and purposes like any other directory,
except for the fact that it can be mounted with the command
```
mount -o subvol=[name of subvol] [btrfs filesystem] [mountpoint]
```
That lets you name your subvolume anything, and be assured that after
mounting it will be in place, but crucially it still exists as
something that looks a lot like a directory even without mounting it.

So if your filesystem looks like this, subvolumes in brackets, you don't
even need to add your subvolumes to your fstab:

```
[/]
|- etc  
|- bin  
|- ...  
|- [home] 
|  |- userman  
```

The subvolumes '/' and 'home' behave for all the world like directories,
but if you take a snapshot of **/** it won't include **home**.  In all
actuality, you won't even have a separate subvolume called **/**, you'll
just mount your top level volume as root.

Which brings me to the top level volume.  This confused me a lot at
first, but you can think about it as the actual BTRFS partition itself.
You know how if you just mounted, say, /dev/sda1 at /mnt/usb, whatever
filesystem is there would just get mounted? If the filesystem was
formatted with BTRFS, you've just mounted the top level volume.  That's
why when you mount a subvolume somewhere, you use the '-o' flag to
specify a subvolume *within* the partition.

(In truth the one that gets mounted is the default subvolume, but there
is rarely a need to have the default be anything other than the top
level)

The problem comes when using snapshots to revert, or back up, your
system.  It's far easier when all of your subvolumes and snapshots are
under the top level subvolume, and mounted to place as needed.  That
means that my file structure looks more like this:

```
toplevel
|- [/] -> /
|- [home] -> /home
|- [snapshots] -> /.snapshots
|  |- root
|  |  |- [today-snapshot]
|  |  |- [yesterday-snapshot]
|  |- home
|  |  |- [today-snapshot]
|  |  |- [yesterday-snapshot]
```

Those snapshots aren't mounted anywhere, but if I need just a single
file I can just copy it from /.snapshots/root/today/etc/whatever as 
though the snapshot was just a simple directory.  The advantage here is
that if I need to completely revert, I can just boot from an Arch usb
and move the snapshot of my choice to toplevel/home like I was just
moving a directory, and when I reboot it'll be like nothing ever
happened.

The only other note is that when you need to specify the 'path' to a
subvolume, it's relative to the top level subvolume.  If I wanted to
mount **today-snapshot** at /mnt/recent, I'd use the command

```
mount -o subvol=snapshots/root/today-snapshot [partition] /mnt/recent
```

For backup and snapshot management I use
[btrbk](https://github.com/digint/btrbk), which I can't recommend highly
enough.  The only difficulty I had with it was working out that it
needed the top level mounted somewhere to get a path to the subvolumes,
which I wasn't used to.  Now I just stick it at /mnt/top-level.  
  
### LUKS

LUKS is the handy full disk encryption tool that the wiki recommends.  I
also recommend it entirely, and if you follow the 
[LVM on LUKS](https://wiki.archlinux.org/index.php/Dm-crypt/Encrypting_an_entire_system#LVM_on_LUKS)
method you'll be just fine.  I was worried it would interact strangely
with BTRFS or UEFI, but it didn't at all.  Worry not is my final
takeaway for this one.

### Booting and UEFI

This is going to be the most specific to the individual user.  If you're
concerned about the possibility of an evil maid attack, you probably
want to encrypt your boot.  If you're not using UEFI, or using a
slightly different version of UEFI, you might need to to any number of
things.  I'm just going to go over the basics of my setup.  
  
My UEFI boot partition is on a different disk than my arch install, and
I keep my arch boot partition separate from the UEFI boot partition.
That means that I have /dev/nvme1n2 mounted at /efi, and /dev/nvme0n3
mounted at /boot.  /boot contains your kernels and such, and /efi
includes all your boot entries.

While we're on the topic, I should go over bootloaders.  The installation
guide helpfully recommends that you have one, which isn't wrong.  I use
grub, because I'm used to it and it doesn't suck all that much.
Installing grub on UEFI is trivial as long as you go follow the
instructions on the GRUB wiki page.  I'm thinking about switching my
boot partition to a boot subvolume within the encrypted partition, which
will be a little weirder, but one way or the other the UEFI partition
needs to stay where it is.

GRUB auto detected my Windows partition with no issue.  I only use
Windows to play a specific video game, but it's an important specific
video game so I keep it around.

### Working Models

I am aware that many of the things I explained were technically
incorrect.  In particular, I'm sure that my understanding of BTRFS
subvolumes is sub-par.  I don't think that it's a waste to write it down
though.  For a lot of users, working with things like the filesystem or
bootloader is really confusing and often scary.  I know I spent a long
time reading wiki pages and learning nothing before things started to
click.  What helps is having a working model, even if you don't know
what's actually going on under the surface.  
  
I don't know if I imparted my models of these things, or if its helpful
for anyone else.  I do hope that at least it's clear that these things
aren't as complicated as it seems, and that if even an idiot like me can
learn enough to work with them, you can too.  
  
On another note, I think that this is what the real benefit of an Arch
install is.  It's not uncommon for members of the community to say that
installing Arch teaches about how Linux works.  It's also not uncommon
to hear that installing Arch is easy: just follow the manual.  I think
that both can be true, but not at the same time.  It's true that I never
would have learned any of this if I hadn't knuckled down and installed
Arch.  However, I also wouldn't have learned anything had there been a
complete manual for me.  What I learned wasn't *how* to install arch,
although I now expect I wouldn't have any trouble, it was the working
models that I now use to fix my computer when it breaks.  That's why I
don't have an installation guide here, besides the fact that it would
soon be outdated.  Just another set of steps would be useless,
especially since once you have an idea of what the components of your
system do you can just follow the steps on the wiki without much worry.
These are the building blocks, and with them a new install is as simple
as LEGOs.
