---
title: "Security Through Obscurity"
---
## Security Through Obscurity

I'd like to preface this article by saying that I am by no means a security expert.  I don't work in a security field; really I don't work at all.  This is mostly just my musings on the online discussions I have seen for quite some time.  Please don't take this as security advice if you know better, though if you don't it's no better or worse to listen to me.  Consider yourself warned.

So, security through obscurity.  As everyone knows, security through obscurity is no defense at all.  Hoards of internet know-it-alls love to crawl from the woodwork whenever anyone suggests moving ssh to a non-standard port or even using a self-signed secure boot.  "Security Through Obscurity! Security Through Obscurity!", they call like seagulls on a beach.  The advice is trotted out so consistently that it seems inarguable, and indeed there is a very real kernel of truth.  On its own security through obscurity isn't a defense at all.  That being said, I'm going to go against conventional wisdom here and say that in almost every discussion I've seen, a little more obscurity wouldn't have been amiss.

### Why Obscurity is Bad

Before I dive into this, I'll go over the situations where the critics are correct.  Security through obscurity is not a replacement for security best practices.  To illustrate we can take a look at the most common example of this debate: internet facing ssh ports.  Newbies to self-hosting servers often ask online if they can forward a port to their server's port 22, and access ssh from outside.  In this situation, there are a number of accepted best practices: disable root login entirely, disable password login, and use SSH keys.  All of those things are absolutely true and I of course do the same on my home server.

However, it is also sometimes brought up that its possible to just move ssh to a non-standard port.  That's what starts the debate.  The basic argument against security through obscurity says that allowing password or root login on any port is idiotic, and you might as well not have any attempt at security at all.  That is absolutely correct; a nonstandard port is no substitute for more effective security.  The same argument can be made in almost every debate on similar issues.  When the door is left unlocked, tucking it behind a curtain isn't going to cut it.

### Why Obscurity is Good

Of course, I wouldn't be writing this is I completely agreed with the conventional wisdom.  There are very real reasons to doubt security exclusively through obscurity, but in many cases the more vocal critics are simply incorrect.  I think that this is true for a few reasons:

- Something You Know: The classic corner of identity proof is technically obscurity-based; carrying the logic forward rounds out some more defense that looks like security through obscurity

- Shallow Threat Model: The threats that many people face are simply not state actors or well-resourced targeted attacks.  Instead, the default threat model is a shallow attack intended to get the most bang for the buck, and like friends fleeing in the woods, it's just not necessary to outrun the bear

- Defense in Depth: Even many complicated attacks rely on single-shot success.  A multistage attack can, with preparation, evade any defense that is known, but will fail upon hitting even a single unknown

I'll go into more depth on each of these points, but the unifying theme is that ultimately defense-space begins very large, and building an attack to slip through the cracks relies on knowing where the cracks on.  You shouldn't leave your front door open, but neither should you do your attackers any favors by narrowing their search-space.  To spoil the ending, yes I run ssh on a non-standard port.  My logs were growing my kilobytes a day, and almost every attack is a simple botnet that just isn't going to spend orders of magnitude more time scanning every port they can, especially because once they do they'll still find themselves working with a password disabled ssh.  It just doesn't make sense to do it any other way.

### Something You Know

My root login is protected by a password. I'm confident that this is a secure measure because I am the only one that knows my password.  That is the most secure application of security through obscurity.  Of course, no one thinks that a password is poor defense, at least for local systems.  That's not because it doesn't rely on obscurity, its because the correct answer is *very* obscure.  Less obscure measures are less secure, but there's no reason to think that they don't help at all.

This isn't to say that just moving an ssh port is worth as much as a password.  Instead, I mean to point out that in principle almost every security measure we rely on boils down to obscurity.  Simply shouting "Security through obscurity!!" at the top of your lungs isn't an argument, you need to specify how this particular method is poor security.  Keep that in mind.

### Shallow Threat Model

Two friends are camping in the woods, when an enraged bear bursts into their clearing.  The two immediately begin to run, but the bear is significantly faster.  One breathlessly asks the other "Why are we even running, the bear will catch us?", to which the other of course replied "I don't need to outrun the bear, I need to outrun you."  We've all heard the joke, but for many threats it actually holds true.  The average home server is primarily attacked by bots looking for a handful of common vulnerabilities.  These attackers focus on quantity over quality, and considering the spectacular difference in searching through every possible port and scanning a known handful before moving on, there's no question that so long as more than 30 people on earth expose venerable services on standard ports, a significant majority of all attacks will be going for those ports and nothing else.  Sure you shouldn't skip the keys and the passwords, but there's no denying that moving ports cuts down on the log size.

By a similar token, the next threat up the ladder is the script kiddy.  Armed with outdated Youtube tutorials and a Kali VM, they aren't a real threat against a properly prepared system.  However, this flavor of threat is most likely to come from a more vulnerable location.  For instance, I'm currently attending college.  My most significant threat isn't being Mossod-ed upon, it's a fellow student and a mistakenly unlocked laptop.  The script kiddy's reliance on specific tools and tutorials without real knowledge of the underlying system is a fundamental part of the threat model, and simply having a system that runs a little out of the ordinary may well be enough to thwart them, *even if a more knowledgeable attacker would have been handed the keys to the kingdom*.  I half consider advising that if a script kiddy is a part of your threat model, prevent your bash prompt from displaying when you are running on root.  Obviously its more important that you don't accidentally do something as root than that script kiddies get confused, but you get the idea.

### Defense In Depth

Tying into the point above, no matter how tight your security, you need to be prepared for the eventuality that you fuck up personally.  As tight as your external security should be, your system should have layers like an onion as well.  Would your perimeter hold tight if you left your laptop unlocked? If someone got on your wifi? If one of your users lost their password? Obviously things like using sudo instead of habitually logging in as root and locking the screen after a period of inactivity are both helpful, but I hold that defense in depth fundamentally implies a degree of obscurity as well.

There are a few ways to think about this.  The first is in preventing any single point of failure.  If you take measures to ensure that knowledge of the system internals requires breaching some security to start with, a prospective attacker needs to breach security, then devise their next attack, then implement it.  With good logging, that won't go unnoticed.  Just because the obscurity isn't enough security on its own doesn't mean that it serves no security purpose, far from it.

Another way that obscurity can help provide defense in depth is in the case of what I'll call tripwires.  A tripwire is almost the definition of security through obscurity; its useless if the attacker knows where it is.  In a digital context, that means alerts of suspicious activity, or even just normal activity that an attacker might want to attempt.  This provides no security on its own, but when combined with other measures a slowdown is most of the way to success.  Extending this idea a little bit, the previous point falls under tripwires as well; forced checkpoints where an attacker needs to pause and assess, allowing an administrator to notice and take action.

Perhaps most important, and the one I find myself thinking of most often, is that most well resourced and dangerous attacks, the kind that nation states pull off, are essentially single shot.  Stuxnet took several attempts to slip into the nuclear facility, but once it got in it had to operate without outside help at all.  The attackers (which *certainly* weren't the US and Israel) used mockups in a lab setting to devise the attack over the course of months.  That attack would have been impossible if the facility had kept its secrets better.

That may seem like a silly point, but I see people making arguments against practices on the grounds of their being "security through obscurity" that make absolutely no sense.  It seems that people really think that literally any hole in security at all is enough to render the whole endeavor useless.  In many cases, that just isn't true.  Most attacks are one-shot, and a little obscurity can make them simply impossible.

### Case Studies

I'll avoid linking directly to people, so you'll have to take my word that I'm not strawmanning.  We've already discussed enough the ssh port example, but there are plenty more.

**Encrypted Disk**: I encrypt my root partition, but keep boot separate.  There are those who would say that this is pointless, because it offers no protection against an Evil Maid attack.  I disagree entirely, but when I or someone else points out that encrypting root, home, and swap prevents an attacker from determining almost anything about your system, and an evil maid attack would require extended access to the machine without my noticing, the accusation of security through obscurity rings out.  I shouldn't have to mention that *this is insane*.  An attacker who doesn't know what the setup is will not be successful, that's what security is.

On another point, suspending with an encrypted root keeps the key stored in ram, meaning that a laptop thief would hypothetically be able to extract the key from ram without knowing the password, and decrypt the disk.  I personally have my swap partition in an LVM volume on top of LUKS, and hibernate very quickly after suspending, but frankly I'm still not very concerned about suspending.  For one, such an attack requires a great deal of specialist equipment and skill that far outstrips the requirements of rubber-hose decryption, but for another an attacker would need to *know* that my system is set up like that.  They would need to incorporate it into their plan to begin with, waiting for the exact instant I move away from my computer to snatch it before it hibernates.

**DIY Secure Boot**: It's possible on arch to sign your bootloader so UEFI secure boot will work.  Of course, to do this properly you would have an airgapped signing server, and ship out the kernel after every update.  Otherwise anyone with access to your unlocked machine could attempt an Evil Maid attack!

Of course, anyone with access to your unlocked machine doesn't need to use an attack with a whitepaper:successful attempt ratio in the high hundreds.  Even more importantly, there are a handful of attacks that try to exploit an unsecured kernel that aren't an Evil Maid attack, such as Drovorub, which are frustrated by UEFI secure boot.  Obviously a dedicated attacker could find a local key and sign their new module, but just posessing Drovorub malware doesn't impart the ability to do that.  If you cook your own solution, its even harder to figure out how to exploit.  Once again, I've seen cries of security theater and obscurity, but it really can make sense to sign your own kernel.

### Conclusions

At the end of the day, the unifying message is that no bank robber wouldn't kill for blueprints.  Denying them blueprints isn't going to beat a locked vault, but a locked vault in a secret location may well come close to unbeatable.  Is security through obscurity a solution in and of itself? No, absolutely not.  Are closed source projects more secure because people can't see the code? No, absolutely not.  Is a security measure completely useless if it involves an attacker's lack of knowledge? Well that's a no too.  Keep your secrets.
