---
title: Switching To BSPWM
---

## Switching To BSPWM

Unlike many linux newbies, I haven't done much distro hopping.  Technically I started on Ubuntu, and eventually I expect I'll switch to Arch, and put together a simple archiso in the long run, for the past two years I've been working almost exclusively on Manjaro.

That being said, I've played around more with my desktop environment.  To start I used XFCE (which is an excellent option if you want the trappings of a desktop environment), but I experimented with KDE as well.  Once I learned about window managers, I quickly switched to I3, and discovered a love of tiling in general.  Once I got a new laptop, a [thinkpad x1 extreme](https://wiki.archlinux.org/index.php/Lenovo_ThinkPad_X1_Extreme), I used Manjaro Architect to install i3 alone, and for a time I was happy.

Eventually, however, I found i3 increasingly hard to debug and work with.  Features I wanted were hard to find, features I didn't care to configure took up much of my config file, and the lack of support for scripting made it a real hassle to do the hacking together that I enjoy.  That's why I switched to BSPWM, and I haven't looked back since.

### What Makes BSPWM So Great Huh?

The main reason BSPWM offers more options than i3 is because it's configured entirely in shell.  Actually, it just takes messages on a standard Unix pipe, but in practice it's just shell.  That means that it's not just configurable, its hackable by *default*.  The main example in window swallowing, where a lightweight script running as a daemon in the background hides your terminal whenever you open another program with it, creating a way more compact file-using experience.  It's probably possible on i3, somehow, but in BSPWM its a 30 line shell script.

The sad fact of the matter is that I'm just bad at programming.  I don't know enough about the underlying systems of my computer to really use it correctly.  Instead, I throw things together like lego blocks, patching together half remembered snippits and copy-pasted forum posts.  This is a hobby for me, not a job, and I'll be damned if I ever don't suck at it.  BSPWM favors this kind of bad programming, (as well as actually good programming), because it's so scriptable.  That's why I went for it rather than awesome or xmonad.

### The Switching Process

The installation process is trivial, but you have to remember that just installing the package isn't enough.  On an arch based system, just run:
```
pacman -S bspwm sxhkd
```
This will download BSPWM and SXHKD, which stands for Suckless X Hotkey Daemon.  You'll need a hotkey daemon (and SXHKD is actually made for this) because BSPWM doesn't have keyboard shortcuts on its own.  After you install, just copy the default configuration with:
```
cp /usr/share/doc/bspwm/examples/bspwmrc ~/.config/bspwm/bspwmrc
cp /usr/share/doc/bspwm/examples/sxhkdrc ~/.config/sxhkd/sxhkdrc
```
If you don't run URxvt, edit sxhkdrc so the terminal shortcut opens the terminal of your choice.  While you're in, edit some keybindings if you don't like them.  After that, make sure bspwmrc is executable, and you're done.  I use LightDM, which automatically detects BSPWM and gives an option to simply log in.  Now I'm happily using my new window manager, and I'm quite enthused to really make it my own.
